% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{FitKinetics}
\alias{FitKinetics}
\title{Fit kinetic models to all genes.}
\usage{
FitKinetics(
  data,
  name.prefix = "kinetics",
  type = c("nlls", "ntr", "lm", "chase"),
  slot = DefaultSlot(data),
  time = Design$dur.4sU,
  CI.size = 0.95,
  return.fields = c("Synthesis", "Half-life"),
  return.extra = NULL,
  ...
)
}
\arguments{
\item{data}{A grandR object}

\item{name.prefix}{the prefix of the analysis name to be stored in the grandR object}

\item{type}{Which method to use (either one of "full","ntr","lm", "chase")}

\item{slot}{The data slot to take expression values from}

\item{time}{The column in the column annotation table representing the labeling duration}

\item{CI.size}{A number between 0 and 1 representing the size of the confidence interval}

\item{return.fields}{which statistics to return (see details)}

\item{return.extra}{additional statistics to return (see details)}

\item{...}{forwarded to \code{\link{FitKineticsGeneNtr}}, \code{\link{FitKineticsGeneLeastSquares}} or \code{\link{FitKineticsGeneLogSpaceLinear}}}
}
\value{
A new grandR object with the fitted parameters as an analysis table
}
\description{
Fit the standard mass action kinetics model of gene expression by different methods. Some methods require steady state assumptions, for others
data must be properly normalized. The parameters are fit per \link{Condition}.
}
\details{
The start of labeling for all samples should be the same experimental time point. The fit gets more precise with multiple samples from multiple
labeling durations.

The standard mass action kinetics model of gene expression arises from the following differential equation:

\deqn{df/dt = s - d  f(t)}

This model assumes constant synthesis and degradation rates. Based on this, there are different ways for fitting the parameters:
\itemize{
  \item{\link{FitKineticsGeneLeastSquares}: non-linear least squares fit on the full model; depends on proper normalization; can work without steady state; assumption of homoscedastic gaussian errors is theoretically not justified}
  \item{\link{FitKineticsGeneLogSpaceLinear}: linear model fit on the old RNA; depends on proper normalization; assumes steady state for estimating the synthesis rate; assumption of homoscedastic gaussian errors in log space is problematic and theoretically not justified}
  \item{\link{FitKineticsGeneNtr}: maximum a posteriori fit on the NTR posterior transformed to the degradation rate; as it is based on the NTR only, it is independent on proper normalization; assumes steady state; theoretically well justified}
}

Pulse-chase designs are fit using \link{FitKineticsGeneLeastSquares} while only considering the drop of labeled RNA. Note that in this case the notion "new" / "old" RNA is misleading,
since labeled RNA corresponds to pre-existing RNA!

This function is flexible in what to put in the analysis table. You can specify the statistics using return.fields and return.extra (see \code{\link{kinetics2vector}})
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))
sars <- FilterGenes(sars,use=1:10)
sars<-FitKinetics(sars,name="kinetics.ntr",type='ntr')
sars<-Normalize(sars)
sars<-FitKinetics(sars,name="kinetics.nlls",type='nlls')
sars<-FitKinetics(sars,name="kinetics.lm",type='lm')
head(GetAnalysisTable(sars,columns="Half-life"))

}
\seealso{
\link{FitKineticsGeneNtr}, \link{FitKineticsGeneLeastSquares}, \link{FitKineticsGeneLogSpaceLinear}
}
\concept{kinetics}
