% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{grow}
\alias{grow}
\title{Function \code{grow}}
\usage{
grow(..., list = character(0), from = parent.frame(), to = parent.frame())
}
\arguments{
\item{...}{characters or symbols, names of functions to make into
binary operators.}

\item{list}{character vector of names of functions to make into
binary operators}

\item{from}{package (character scalar) or environment to look 
for functions to turn into binary operators.}

\item{to}{environment to store the new binary operators.}
}
\description{
Turn a collection of functions into binary operators. For
example, create the binary operator \code{\%cbind\%} from the function
\code{\link{cbind}()} by calling \code{grow(cbind)}. Then,
you can call \code{sleep \%cbind\% sleep \%cbind\% sleep} to add
to the columns of a data frame while avoiding cumbersome parentheses.
}
\examples{
grow(rbind, from = "base") # Use `from` to specify a package or environment to search.
nrow(sleep) # 20
longer = sleep \%rbind\% sleep \%rbind\% sleep # No clumsy parentheses!
nrow(longer) # 60. Most of us would like to sleep longer.
}

