% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_ppv.R
\name{all_opt_ppv}
\alias{all_opt_ppv}
\title{Optimize All Probabilistic Path Values}
\usage{
all_opt_ppv(sociomatrix, odds_scale = 1, odds_scale_by_node = NULL)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{odds_scale}{a nonnegative real number indicating the observed tie
strength value that corresponds to 1-1 transmission odds}

\item{odds_scale_by_node}{sets a transfer odds scale for each node in a 
probabilistic path value calculation.}
}
\value{
All optimal paths from source to target nodes in \code{sociomatrix}. To
    minimize memory usage, paths are returned as a list of trees in Dijkstra's 
    format. Specific paths can be unpacked with \code{unpack} as described in the
    example below.
}
\description{
Identify the path of optimal probabilistic path value from every source 
to every target in \code{sociomatrix}.
}
\seealso{
\code{\link{ppv}} to calculate the value of a user-specified path, 
    \code{\link{opt_ppv}} to identify the optimal path from a single source 
    node to a single target node
}
