% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmsem.fcoher.R
\name{grmsem.fcoher}
\alias{grmsem.fcoher}
\title{grmsem factorial co-heritability and co-environmentality estimation function.}
\usage{
grmsem.fcoher(grmsem.out = NULL)
}
\arguments{
\item{grmsem.out}{grmsem.fit or grmsem.stpar object. Default NULL.}
}
\value{
\code{grmsem.fcoher} returns an extended model.out dataframe, fcoher.model.out, with the following columns:
\item{label}{parameter label}
\item{estimates}{estimated parameters}
\item{gradient}{gradient}
\item{se}{SE}
\item{Z}{Z (Wald) of factor loading}
\item{p}{p (Wald) of factor loading}
\item{Vi}{squared factor loading, explained phenotypic variation by the factor}
\item{Vi.se}{SE of squared factor loading}
\item{FCOHER}{factorial co-heritability}
\item{FCOHER.se}{SE of factorial co-heritability}
\item{FCOHER.Z}{Z (wald) of factorial co-heritability}
\item{FCOHER.se}{p (Wald) of factorial co-heritability}
\item{FCOENV}{factorial co-environmentality}
\item{FCOENV.se}{SE of factorial co-environmentality}
\item{FCOENV.Z}{Z (wald) of factorial co-environmentality}
\item{FCOENV.se}{p (Wald) of factorial co-environmentality}
}
\description{
This function estimates factorial co-heritabilities and factorial co-environmentalities.
}
\details{
The \code{grmsem.fcoher} function can be used to estimate factorial co-heritabilities and factorial co-environmentalities 
for models estimating latent variables (Cholesky, IP or IPC models), based on \code{grmsem.fit} or \code{grmsem.stpar} objects.
The factorial co-heritability of a genetic factor m for trait t is the ratio of the genetic variance explained by factor m (A_mt) to the total genetic variance (A_t): A_mt / A_t. 
The factorial co-environmentality of a residual factor n for trait t is the ratio of the residual variance explained by factor n (E_nt) to the total residual variance (E_t):  E_nt / E_t.
All standard errors are derived with the Delta method.
}
\examples{
#(runtime should be less than one minute)
\donttest{
out <- grmsem.fit(ph.small, G.small, LogL = TRUE, estSE = TRUE)
grmsem.fcoher(out)}
}
\keyword{grmsem}
