% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmsem.stpar.R
\name{grmsem.stpar}
\alias{grmsem.stpar}
\title{grmsem standardised parameters function}
\usage{
grmsem.stpar(grmsem.out = NULL)
}
\arguments{
\item{grmsem.out}{grmsem.fit object as provided by the grmsem.fit function. Default NULL.}
}
\value{
\code{grmsem.stpar} returns a list object consisting of:
\item{model.in}{list of input parameters}
\item{stand.model.out}{dataframe of fitted grmsem model with standardised parameters and SEs}
\item{stVCOV}{standardised variance/covariance matrix}
\item{k}{number of phenotypes}
\item{n}{total number of observations across all phenotypes}
\item{model}{type of grmsem model}
\item{ph.nms}{vector of phenotype names}

\code{model.in} list of input parameters:
\item{part}{a - genetic, e - residual parameters}
\item{label}{parameter label}
\item{value}{starting values}
\item{freepar}{free parameters}

\code{stand.model.out} data.frame of fitted grmsem model with standardised parameters and SEs:
\item{label}{parameter label}
\item{estimates}{standardised estimated parameters}
\item{se}{SE}
\item{Z}{Z (Wald)}
\item{p}{p (Wald)}
}
\description{
This function estimates standardised parameters for a grmsem.fit object.
}
\details{
\code{grmsem.stpar} standardises grmsem.fit estimates so that derived or estimated A and E variance components will add up to phenotypic unit variance. 
The SEs of standardised parameters are derived using the Jacobian matrix.
}
\examples{
#(runtime should be less than one minute)
\donttest{
out <- grmsem.fit(ph.small, G.small, LogL = TRUE, estSE = TRUE)
stout <- grmsem.stpar(out)
print(stout)}
}
\keyword{grmsem}
