% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree-itempar.R
\name{itempar_grmtree}
\alias{itempar_grmtree}
\title{Extract Item Parameters from GRM Tree}
\usage{
itempar_grmtree(object, node = NULL, ...)
}
\arguments{
\item{object}{A \code{grmtree} object.}

\item{node}{Optional vector of node IDs to extract from. If NULL (default),
extracts from all terminal nodes.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data.frame with item parameters for each item in each node, with columns:
\item{Node}{Node ID}
\item{Item}{Item name}
\item{Discrimination}{Discrimination parameter (a1)}
\item{AvgThreshold}{Average of threshold parameters}
\item{Thresholds}{All threshold parameters as a list column}
}
\description{
Extracts both discrimination parameters and average threshold parameters for each item
from all terminal nodes of a graded response model tree. This provides a comprehensive
view of item characteristics across different nodes of the tree.
}
\examples{
\donttest{
  library(grmtree)
  library(hlt)
  data("asti", package = "hlt")
  asti$resp <- data.matrix(asti[, 1:4])

  # Fit GRM tree with gender and group as partitioning variables
  tree <- grmtree(resp ~ gender + group,
          data = asti,
          control = grmtree.control(minbucket = 30))

  # Get all item parameters
  items <- itempar_grmtree(tree)
  print(items)
}

}
\seealso{
\code{\link{grmtree}} fits a Graded Response Model Tree,
\code{\link{grmforest}} for GRM Forests,
\code{\link{fscores_grmtree}} for computing factor scores,
\code{\link{threshpar_grmtree}} for extracting threshold parameters,
\code{\link{discrpar_grmtree}} for extracting discrimination parameters
}
