% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrange_genos.R
\name{rearrange_genos}
\alias{rearrange_genos}
\title{rearrange genotypes into separate columns for each haplotype.}
\usage{
rearrange_genos(G, Im, Mm)
}
\arguments{
\item{G}{the genotype matrix (N rows and 2L columns)}

\item{Im}{the meta data for the N samples.}

\item{Mm}{the meta data for the L markers.}
}
\value{
Returns a list. Each component of the return list is itself
an unnamed list with one component (makes it easier to use \code{bind_rows} to
create a tibble of list columns from these).  The components, once unlisted are:
\itemize{
\item \code{G}: a matrix---the rearranged genotype data matrix
\item \code{I}: the I_meta tibble
\item \code{M}: the M_meta tibble
}
}
\description{
This function first reorders individuals in the columns of
the matrix so that every population is together.  Then it
rearranges genotypes into separate columns for each haplotype
(or "halflotype" if they are unphased.)  This prepares the matrix
for different kinds of a permutation (within or between populations,
for example).
}
\details{
It returns a list.  One component is the matrix, another is the
updated individual meta data, and the third is the marker meta
data.
}
\examples{
RG <- rearrange_genos(Geno, I_meta, M_meta)
}
