\name{print.summary.gsearly}
\alias{print.summary.gsearly}
\title{Print a gsearly model summary}
\usage{
\method{print.summary}{gsearly}(x, digits=4, ...)
}
\description{Prints a gsearly model summary.}
\arguments{
 \item{x}{A fitted gsearly object from function \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}}.}
 \item{digits}{The number of digits required for numeric output.}
 \item{...}{Further arguments passed to print (not currently implemented).}
}
\value{
 A list  containing the following components
 \item{title}{Package name and version number.}
 \item{call}{Call used to create \code{mod}.}
 \item{rdata}{See details in \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}}.}
 \item{idata}{See details in \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}}.}
 \item{power}{See details in \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}}.}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(16,31), pow=0.8,
                   cmodel="exponential", sd=20, rho=0.75, theta=8, fp=fp, tn=tn)
 summary(rctdesign)
 str(summary(rctdesign))

}
