% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SAAR}
\alias{gsw_SAAR}
\title{Absolute Salinity Anomaly Ratio}
\usage{
gsw_SAAR(p, longitude, latitude)
}
\arguments{
\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{longitude}{longitude in decimal degrees, positive to the east of Greenwich. (This
is called \code{long} in the TEOS-10 Matlab code.)}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
a list containing \code{SAAR}, which is
the (unitless) Absolute Salinity Anomaly Ratio, and \code{in_ocean}
is set to 1 if \code{SAAR} is nonzero, or to 0 otherwise.
}
\description{
Absolute Salinity Anomaly Ratio
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\section{Bugs}{

The definition of \code{in_ocean} is incorrect, because the C function named
\code{gsw_saar}, which is called by the present R function, does not calculate
\code{in_ocean}, as the base Matlab function named \code{gsw_SAAR} does. However,
examination of the Matlab code shows that \code{in_ocean} is set to 0 along
with \code{SAAR}, whenever the original estimate of the latter is nonfinite.
Thus, points that would be signalled as being on the land by the Matlab code
are indicated in the same way with the present R function. However, other points
may also be indicated as being on land, if \code{SAAR} is simply zero in the
first calculation. Whether this poses a problem in practice is an open question,
since it seems likely that this function would only be called with oceanic
locations, anyway. If problems arise for users, a patch can be written to
improve things.
}

\examples{
p <- c(10, 50, 125, 250, 600, 1000)
longitude <- c(188, 188, 188, 188, 188, 188)
latitude <- c(4, 4, 4, 4, 4, 4)
SAAR <- gsw_SAAR(p, longitude, latitude)
stopifnot(all.equal(1e3*SAAR$SAAR, c(0.004794295602143, 0.007668755837570, 0.018919828449091,
                                     0.077293264028981, 0.161974583039298, 0.270652408428964)))
stopifnot(all.equal(SAAR$in_ocean, rep(1, 6)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SAAR.html}
}
