% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_second_derivatives}
\alias{gsw_entropy_second_derivatives}
\title{Second Derivatives of Entropy}
\usage{
gsw_entropy_second_derivatives(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{CT}{Conservative Temperature [ degC ].}
}
\value{
A list containing \code{eta_SA_SA} [ (J/(K*kg))/(g/kg)^2 ], the second derivative of
entropy with respect to Absolute Salinity, \code{eta_SA_CT} [ (J/(K*kg))/(K*g/kg) ], the derivative of
entropy with respect to Absolute Salinity and Conservative Temperature,
and \code{eta_CT_CT} [ (J/(K*kg))/K^2 ], the second derivative of
entropy with respect to Conservative Temperature.
}
\description{
Second Derivatives of Entropy
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
r <- gsw_entropy_second_derivatives(SA, CT)
stopifnot(all.equal(r$eta_SA_SA, c(-0.007627718929669, -0.007591969960708, -0.007528186784540,
                                   -0.007455177590576, -0.007441108287466, -0.007414368396280)))
stopifnot(all.equal(r$eta_SA_CT, c(-0.001833104216751, -0.001819473824306, -0.001580843823414,
                                   -0.000930111408561, -0.000717011215195, -0.000548410546830)))
stopifnot(all.equal(r$eta_CT_CT, c(-0.043665023731109, -0.043781336189326, -0.045506114440888,
                                   -0.049708939454018, -0.050938690879443, -0.051875017843472)))

}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_second_derivatives.html}
}
