% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guild.R
\name{guild_view}
\alias{guild_view}
\title{Launch Guild Viewer}
\usage{
guild_view(
  runs = NULL,
  ...,
  host = NULL,
  port = NULL,
  include_batch = FALSE,
  no_open = FALSE,
  stop = FALSE
)
}
\arguments{
\item{runs}{an optional runs selection.}

\item{...}{passed on to \verb{guild view}.}

\item{host}{Name of host interface to listen on.}

\item{port}{Port to listen on.}

\item{include_batch}{(bool) Include batch runs.}

\item{no_open}{(bool) Don't open Guild View in a browser.}

\item{stop}{Stop the existing Guild View application.}
}
\value{
The url where the Guild View application can be accessed.

The url where the View application can be accessed,
invisibly.
}
\description{
Launch Guild Viewer
}
\examples{
\dontrun{
  guild_view()

  # see all supported options
  guild_view("--help")

  # three valid ways of supplying args to the guild executable
  guild_view("--port" = "5678")
  guild_view("--port", "5678")
  guild_view(c("--port", "5678"))
}
}
