% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_guild_cli}
\alias{install_guild_cli}
\title{Install guild for usage in the Terminal}
\usage{
install_guild_cli(
  dest = "~/bin",
  completions = basename(Sys.getenv("SHELL")) \%in\% c("bash", "zsh", "fish")
)
}
\arguments{
\item{dest}{Directory where to place the \code{guild} executable. This should
be a location on the \code{PATH}.}

\item{completions}{Whether to also install shell completion helpers.}
}
\value{
path to the installed guild executable, invisibly.
}
\description{
This function makes available the \code{guild} executable installed by
\code{install_guild()} for usage in the Terminal.
}
\details{
Note that the guild executable installed by the R function
\code{install_guild()} is not able to run python operations. To run python
operations with guild, you must install guild into the target python
installation with \verb{pip install guildai}, and ensure that the desired guild
executable is on the \code{PATH}.
}
