% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwzinbr.R
\name{gwzinbr}
\alias{gwzinbr}
\title{Geographically Weighted Zero Inflated Negative Binomial Regression}
\usage{
gwzinbr(
  data,
  formula,
  xvarinf = NULL,
  weight = NULL,
  lat,
  long,
  grid = NULL,
  method,
  model = "zinb",
  offset = NULL,
  distancekm = FALSE,
  force = FALSE,
  int_inf = TRUE,
  maxg = 100,
  h = NULL
)
}
\arguments{
\item{data}{name of the dataset.}

\item{formula}{regression model formula as in \code{lm}.}

\item{xvarinf}{name of the covariates for the zero inflated part of the model, default value is \code{NULL}.}

\item{weight}{name of the variable containing the sample weights, default value is \code{NULL}.}

\item{lat}{name of the variable containing the latitudes in the dataset.}

\item{long}{name of the variable containing the longitudes in the dataset.}

\item{grid}{name of the dataset containing the coordinates for the model locations, default value is \code{NULL}.}

\item{method}{indicates the method to be used for the bandwidth calculation (\code{adaptive_bsq} or \code{fixed_g}).}

\item{model}{indicates the model to be used for the regression (\code{zinb}, \code{zip}, \code{negbin}, \code{poisson}), default value is\code{"zinb"}.}

\item{offset}{name of the variable containing the offset values, if null then is set to a vector of zeros, default value is \code{NULL}.}

\item{distancekm}{logical value indicating whether to calculate the distances in km, default value is \code{FALSE}.}

\item{force}{logical value indicating whether to force the indicated model even if it is not the best fit for the data, default value is \code{FALSE}.}

\item{int_inf}{logical value indicating whether to include an intercept in the zero inflated part of the model, default value is \code{TRUE}.}

\item{maxg}{integer indicating the maximum number of iterations for the zero inflated part of the model, default value is \code{100}.}

\item{h}{integer indicating the bandwidth value (obtained from \code{golden()}), default value is \code{NULL}.}
}
\value{
A list that contains:

\itemize{
\item \code{bandwidth} - Bandwidth value.
\item \code{measures} - Goodness of fit statistics and other measures.
\item \code{qntls_gwr_param_estimates} - Quantiles of GWR parameter estimates.
\item \code{descript_stats_gwr_param_estimates} - Descriptive statistics of GWR parameter estimates.
\item \code{t_test_gwr_param_estimates} - Results for the parameters significance t tests.
\item \code{qntls_gwr_se} - Quantiles of GWR standard errors.
\item \code{descript_stats_gwr_se} - Descriptive statistics of GWR standard errors.
\item \code{qntls_gwr_zero_infl_param_estimates} - Quantiles of GWR zero inflated parameter estimates.
\item \code{descript_stats_gwr_zero_infl_param_estimates} - Descriptive statistics of GWR zero inflated parameter estimates.
\item \code{t_test_gwr_zero_infl_param_estimates} - Results for the zero inflated parameters significance t tests.
\item \code{qntls_gwr_zero_infl_se} - Quantiles of GWR zero inflated standard errors.
\item \code{descript_stats_gwr_zero_infl_se} - Descriptive statistics of GWR zero inflated standard errors.
\item \code{non_stationary_test} - Results for the Non-Stationary Test for GWR parameter estimates.
\item \code{non_stationary_test_zero_infl} - Results for the Non-Stationary Test for GWR zero inflated parameter estimates.
\item \code{global_param_estimates} - Parameter estimates for the global model.
\item \code{analysis_max_like_zero_infl_param_estimated} - Analysis of Maximum Likelihood Zero Inflation Parameter Estimates.
\item \code{analysis_max_like_gof_measures} - Goodness of fit measures for the Analysis of Maximum Likelihood Zero Inflation Parameter Estimates.
\item \code{variance_covariance_matrix} - Variance-covariance matrix.
\item \code{residuals} - Model residuals.
\item \code{param_estimates_grid} - GWR parameter estimates using grid dataset.
\item \code{alpha_estimates} - Estimates for the alpha parameter (for zinb and negbin).
\item \code{gwr_param_estimates} - GWR parameter estimates.
}
}
\description{
Fits a geographically weighted regression model using zero inflated probability distributions. Has the zero inflated negative binomial distribution (zinb) as default, but also accepts the zero inflated Poisson (zip), negative binomial (negbin) and Poisson distributions. Can also fit the global versions of each regression model.
}
\examples{
## Data


data(southkorea_covid19)


## Model

mod <- gwzinbr(data = southkorea_covid19,
formula = n_covid1~Morbidity+high_sch_p+Healthcare_access+
diff_sd+Crowding+Migration+Health_behavior,
lat = "x", long = "y", offset = "ln_total", method = "adaptive_bsq",
model = "negbin", distancekm = TRUE, h=230, force=TRUE)

## Bandwidth
mod$bandwidth

## Goodness of fit measures
mod$measures

}
