% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organize.r
\name{h5_move}
\alias{h5_move}
\title{Move or Rename an HDF5 Object}
\usage{
h5_move(file, from, to)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{from}{The current (source) path of the object (e.g., \code{"/group/data"}).}

\item{to}{The new (destination) path for the object (e.g., \code{"/group/data_new"}).}
}
\value{
This function is called for its side-effect and returns \code{NULL}
invisibly.
}
\description{
Moves or renames an object (dataset, group, etc.) within an HDF5 file.
}
\details{
This function provides an efficient, low-level wrapper for the HDF5
library's \code{H5Lmove} function. It is a metadata-only operation, meaning the
data itself is not read or rewritten. This makes it extremely fast, even
for very large datasets.

You can use this function to either rename an object within the same group
(e.g., \code{"data/old"} to \code{"data/new"}) or to move an object to a
different group (e.g., \code{"data/old"} to \code{"archive/old"}). The destination
parent group will be automatically created if it does not exist.
}
\examples{
file <- tempfile(fileext = ".h5")
h5_write(1:10, file, "group/dataset")

# Review the file structure
h5_str(file)

# Rename within the same group
h5_move(file, "group/dataset", "group/renamed")

# Review the file structure
h5_str(file)

# Move to a new group (creates parent automatically)
h5_move(file, "group/renamed", "archive/dataset")

# Review the file structure
h5_str(file)

unlink(file)
}
\seealso{
\code{\link[=h5_create_group]{h5_create_group()}}, \code{\link[=h5_delete]{h5_delete()}}
}
