% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_reader.R
\name{cff_reader}
\alias{cff_reader}
\title{Citation File Format (cff) reader}
\usage{
cff_reader(x)
}
\arguments{
\item{x}{(character) a file path or a yaml string}
}
\value{
an object of class \code{handl}; see \link{handl} for more
}
\description{
Citation File Format (cff) reader
}
\details{
CFF only supports one citation, so \code{many} will always be
\code{FALSE}.

Required fields:
\itemize{
\item CFF \strong{v1.1.0}: \code{cff-version}, \code{version}, \code{message}, \code{date-released},
\code{title}, \code{authors}.
\item CFF \strong{v1.2.0}: \code{cff-version}, \code{message}, \code{title}, \code{authors}.
}

We'll stop with error if any of these are missing.

You can though have many references in your CFF file
associated with the citation. \code{references} is an optional component in
cff files. If included, we check the following:
\itemize{
\item each reference must have the 3 required fields: type, authors, title
\item type must be in the allowed set, see \link{cff_reference_types}
\item the elements within authors must each be an entity or person object
https://github.com/citation-file-format/citation-file-format#entity-objects
https://github.com/citation-file-format/citation-file-format#person-objects
\item title must be a string
}
}
\examples{
(z <- system.file("extdata/citation.cff", package = "handlr"))
res <- cff_reader(x = z)
res
res$cff_version
res$software_version
res$message
res$id
res$doi
res$title
res$author
res$references

# no references
(z <- system.file("extdata/citation-norefs.cff", package = "handlr"))
out <- cff_reader(x = z)
out
out$references
}
\references{
CFF format:
https://github.com/citation-file-format/citation-file-format
}
\seealso{
Other readers: 
\code{\link{bibtex_reader}()},
\code{\link{citeproc_reader}()},
\code{\link{codemeta_reader}()},
\code{\link{ris_reader}()}

Other cff: 
\code{\link{cff_writer}()}
}
\concept{cff}
\concept{readers}
