% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanct_kmeans.R
\name{hanct_kmeans}
\alias{hanct_kmeans}
\title{Anomaly detector using kmeans}
\usage{
hanct_kmeans(seq = 1, centers = NA)
}
\arguments{
\item{seq}{sequence size}

\item{centers}{number of centroids}
}
\value{
\code{hanct_kmeans} object
}
\description{
Anomaly detection using kmeans
The kmeans is applied to the time series.
When seq equals one, observations distant from the closest centroids are labeled as anomalies.
When seq is grater than one, sequences distant from the closest centroids are labeled as discords.
It wraps the kmeans presented in the stats library.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure k-means detector
model <- hanct_kmeans()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected events
print(detection[(detection$event),])

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
