% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.data.R
\name{read.data}
\alias{read.data}
\title{Read Files in txt, xls, or xlsx Formats}
\usage{
read.data(path, col.names = FALSE, col.types = NULL)
}
\arguments{
\item{path}{Path to the \code{txt}(space-separated), \code{xls} or \code{xlsx} file.}

\item{col.names}{Logical value indicating whether the first row
of the dataset should be used as column names. Use \code{TRUE} to use the first
row as column names or \code{FALSE} otherwise. Default is \code{FALSE}.}

\item{col.types}{Character or a character vector specifying the data types
for each column. Possible values are: "skip" , "guess" , "logical" ,
"numeric", "date" , "text" , or "list" .  Default, it is \code{NULL}, which
means the data types will be determined automatically ("guess").  Note that \code{txt}
files do not support the \code{col.types} parameter.}
}
\value{
Dataset in \code{data.frame} format.
}
\description{
Read datasets files in \code{txt}(space-separated), \code{xls} or \code{xlsx}
and return the data as a \code{data.frame}.
}
\examples{
# Load the package
library(hclusteasy)

# Set the file path
file_path <- system.file("extdata",
                          "iris_uci.xlsx",
                           package = "hclusteasy")


# Read a .xlsx dataset
iris <- read.data(file_path,col.names = TRUE)

}
