% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_checks.R
\name{check_row_na}
\alias{check_row_na}
\title{Find number of and which rows contain any missingness}
\usage{
check_row_na(data, which)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{which}{Logical. Should a list be returned with the row numbers corresponding to each row with missingness? Default set to FALSE.}
}
\value{
Either an integer value corresponding to the number of rows in \code{data} with any missingness (if \code{which = FALSE}), or a tibble containing: 1) number of rows in \code{data} with any missingness, and 2) a list of which rows/row numbers contain missingness (if \code{which = TRUE}).
}
\description{
Find number of and which rows contain any missingness
}
\examples{
\dontrun{
check_row_na(data = any_data_frame, which = FALSE)
}
}
