% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5WriteDataset}
\alias{h5WriteDataset}
\alias{h5WriteDataset.H5D}
\alias{h5WriteDataset.H5Group}
\alias{h5WriteDataset.H5File}
\alias{h5WriteDataset.character}
\title{Write array-like data into an existing H5 dataset}
\usage{
h5WriteDataset(x, robj, ...)

\method{h5WriteDataset}{H5D}(
  x,
  robj,
  idx_list = NULL,
  transpose = FALSE,
  block_size = 5000L,
  verbose = TRUE,
  ...
)

\method{h5WriteDataset}{H5Group}(
  x,
  robj,
  name,
  idx_list = NULL,
  transpose = FALSE,
  block_size = 5000L,
  verbose = TRUE,
  ...
)

\method{h5WriteDataset}{H5File}(
  x,
  robj,
  name,
  idx_list = NULL,
  transpose = FALSE,
  block_size = 5000L,
  verbose = TRUE,
  ...
)

\method{h5WriteDataset}{character}(
  x,
  robj,
  name,
  idx_list = NULL,
  transpose = FALSE,
  block_size = 5000L,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}}, 
\code{\link[hdf5r]{H5D}} or a path name of HDF5 file.}

\item{robj}{An R array.}

\item{...}{Arguments passed to \code{H5D$write()}.}

\item{idx_list}{The indices for each dimension of \code{name} to subset given 
as a list. If \code{NULL}, the entire dataset will be use. Passed to 
\code{\link[hdf5r:H5D-class]{H5D}}\code{$write(args)}}

\item{transpose}{Whether or not to transpose the input matrix. Only works for 
a 2-dimension array-like object.}

\item{block_size}{Default size for number of columns to transpose in a single 
writing. Increasing block_size may speed up but at an additional memory cost.}

\item{verbose}{Print progress.}

\item{name}{Name of the HDF5 dataset to be written.}
}
\value{
This is an operation function and no return. Any failure should raise an 
error.
}
\description{
Low-level helper function to write atomic R data into an existing H5 dataset. 
All data written will be treated as array for HDF5.
}
\note{
If you want to write \code{robj} into scalar space, you should use 
\code{\link{h5WriteScalar}}.
}
\examples{
tmp.file <- tempfile(fileext = ".h5")
h5CreateFile(tmp.file)

# Scalar (will be written into array space for HDF5) ##########
h5CreateDataset(
  tmp.file, 
  name = "test/bool", 
  dims = 1, 
  storage.mode = logical()
) # Must create the dataset first
h5WriteDataset(tmp.file, FALSE, name = "test/bool")
x <- h5Read(tmp.file, name = "test/bool")
x

h5CreateDataset(tmp.file, name = "test/num", dims = 1)
h5WriteDataset(tmp.file, 100.0, name = "test/num")
x <- h5Read(tmp.file, name = "test/num")
x

h5CreateDataset(
  tmp.file, 
  name = "test/string", 
  dims = 1, 
  storage.mode = character()
)
h5WriteDataset(tmp.file, "ABC", name = "test/string")
x <- h5Read(tmp.file, name = "test/string")
x

# Vector (1d array) ##########
x1 <- rep(FALSE, 10)
h5CreateDataset(
  tmp.file, 
  name = "vec/bool", 
  dims = 10, 
  storage.mode = logical()
)
h5WriteDataset(tmp.file, x1, name = "vec/bool")
x <- h5Read(tmp.file, name = "vec/bool")
x

x1 <- rep(1.1, 10)
h5CreateDataset(
  tmp.file, 
  name = "vec/num", 
  dims = 10
)
h5WriteDataset(tmp.file, x1, name = "vec/num")
x <- h5Read(tmp.file, name = "vec/num")
x

x1 <- rep(2.0, 5)
h5WriteDataset(
  tmp.file, 
  x1, 
  name = "vec/num", 
  idx_list = list(c(1, 3, 5, 7, 9)) # Set each indices to be written
)
x <- h5Read(tmp.file, name = "vec/num")
stopifnot(identical(x, rep(c(2.0, 1.1), 5)))

# matrix ##########
x1 <- matrix(1.0, 7, 5)
h5CreateDataset(
  tmp.file, 
  name = "mat/num", 
  dims = dim(x1)
)
h5WriteDataset(
  tmp.file, 
  x1, 
  name = "mat/num"
)
x <- h5Read(tmp.file, name = "mat/num")
x

x1 <- matrix(2.0, 3, 4)
h5WriteDataset(
  tmp.file, 
  x1, 
  name = "mat/num",
  idx_list = list(2:4, 1:4)
)
x <- h5Read(tmp.file, name = "mat/num")
print(x)

h5WriteDataset(
  tmp.file, 
  x1, 
  name = "mat/num",
  idx_list = list(1:4, 2:4),  # idx_list must match the transposed matrix
  transpose = TRUE
)
x <- h5Read(tmp.file, name = "mat/num")
print(x)

}
