% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LassoShooting.fit.R
\name{LassoShooting.fit}
\alias{LassoShooting.fit}
\title{Shooting Lasso}
\usage{
LassoShooting.fit(
  x,
  y,
  lambda,
  control = list(maxIter = 1000, optTol = 10^(-5), zeroThreshold = 10^(-6)),
  XX = NULL,
  Xy = NULL,
  beta.start = NULL
)
}
\arguments{
\item{x}{matrix of regressor variables (\code{n} times \code{p} where
\code{n} denotes the number of observations and \code{p} the number of
regressors)}

\item{y}{dependent variable (vector or matrix)}

\item{lambda}{vector of length \code{p} of penalization parameters for each
regressor}

\item{control}{list with control parameters: \code{maxIter} maximal number
of iterations, \code{optTol} tolerance for parameter precision,
\code{zeroThreshold} threshold applied to the estimated coefficients
for numerical issues.}

\item{XX}{optional, precalculated matrix \eqn{t(X)*X}}

\item{Xy}{optional, precalculated matrix \eqn{t(X)*y}}

\item{beta.start}{start value for beta}
}
\value{
\item{coefficients}{estimated coefficients by the Shooting Lasso
Algorithm} \item{coef.list}{matrix of coefficients from each iteration}
\item{num.it}{number of iterations run}
}
\description{
Implementation of the Shooting Lasso (Fu, 1998) with variable dependent
penalization weights.
}
\details{
The function implements the Shooting Lasso (Fu, 1998) with variable dependent
penalization. The arguments \code{XX} and \code{Xy} are optional and allow to use precalculated matrices which might improve performance.
}
\references{
Fu, W. (1998). Penalized regressions: the bridge vs the lasso.
\emph{Journal of Computational and Graphical Software} 7, 397-416.
}
