% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgv.R
\name{bgv}
\alias{bgv}
\title{Between-group variance (BGV)}
\usage{
bgv(est, se = NULL, pop, conf.level = 0.95, ...)
}
\arguments{
\item{est}{The subgroup estimate. Estimates must be available for at least
85\% of subgroups.}

\item{se}{The standard error of the subgroup estimate. If this is missing,
95\% confidence intervals cannot be calculated.}

\item{pop}{The number of people within each subgroup.Population size must be
available for all subgroups.}

\item{conf.level}{Confidence level of the interval. Default is 0.95 (95\%).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated BGV value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
Between-group variance (BGV) is an absolute measure of inequality that
considers all population subgroups. Subgroups are weighted according to
their population share.
}
\details{
BGV is calculated as the weighted average of squared differences between
the subgroup estimates and the setting average. Squared differences
are weighted by each subgroup’s population share. For more information
on this inequality measure see Schlotheuber (2022) below.

\strong{Interpretation:} BGV has only positive values, with larger values
indicating higher levels of inequality. BGV is 0 if there is no
inequality. BGV is reported as the squared unit of the indicator.
BGV is more sensitive to outlier estimates as it gives more weight to the
estimates that are further from the setting average.

\strong{Type of summary measure:} Complex; absolute; weighted

\strong{Applicability:} Non-ordered dimensions of inequality with more than two
subgroups

\strong{Warning:} The confidence intervals are approximate and might be biased.
See Ahn (2018) below for further information on the standard error formula.
}
\examples{
# example code
data(NonorderedSample)
head(NonorderedSample)
with(NonorderedSample,
     bgv(est = estimate,
         pop = population,
         se = se))
}
\references{
Schlotheuber, A, Hosseinpoor, AR. Summary measures of health
inequality: A review of existing measures and their application. Int J
Environ Res Public Health. 2022;19(6):3697. doi:10.3390/ijerph19063697.

Ahn J, Harper S, Yu M, Feuer EJ, Liu B, Luta G. Variance
estimation and confidence intervals for 11 commonly used health disparity
measures. JCO Clin Cancer Inform. 2018;2:1-19. doi:10.1200/CCI.18.00031.
}
