% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_h_index_to_lonlat}
\alias{hexify_h_index_to_lonlat}
\title{Convert hierarchical index strings to longitude/latitude centers}
\usage{
hexify_h_index_to_lonlat(grid, h_index)
}
\arguments{
\item{grid}{Grid specification from hexify_grid()}

\item{h_index}{Hierarchical index strings (character vector)}
}
\value{
Data frame with columns:
\item{lon}{Longitude in degrees}
\item{lat}{Latitude in degrees}
}
\description{
Converts hierarchical cell index strings back to geographic coordinates,
returning the center point of each cell. This is the inverse operation
of hexify_lonlat_to_h_index().
}
\details{
Most users should use \code{\link{hexify_cell_to_lonlat}} or
\code{\link{hexify_grid_cell_to_lonlat}} which work with DGGRID-compatible
integer cell IDs.
}
\keyword{internal}
