% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_data_constructors.R
\name{DE_data}
\alias{DE_data}
\title{Creates a \code{DE_data} object}
\usage{
DE_data(dat, keep_rownames_as = NULL)
}
\arguments{
\item{dat}{Tibble, results from a differential expression analysis. See Details.}

\item{keep_rownames_as}{Character, the name of the column in which to save the
rownames of the input data-frame. Default value is \code{NULL}, i.e. rownames will
be discarded.}
}
\value{
A \code{DE_data} object, i.e. a tibble.
}
\description{
Creates a \code{DE_data} object from a tibble or data-frame of differential expression
results.
}
\details{
The input data should have one row per gene or transcript, and at least the
following columns:
\itemize{
\item \code{chromosome}: character column, chromosome on which the gene/transcript is located.
\item \code{start} and \code{end}: numeric, starting and end position of the gene/transcript
(in bp). A column \code{position} will be constructed as the middle value (mean) between
\code{start} and \code{end}.
\item \code{score} or \code{padj}: numeric, the DE score or adjusted p-value of the
gene/transcript. If column \code{score} column is missing, will be constructed
as \code{-log10(padj)}.
\item \code{foldChange} or \code{log2FoldChange}: numeric, the fold-change or log2(fold-change)
of the gene/transcript. If column \code{log2FoldChange} is missing, will be constructed
as \code{log2(foldChange)}.
}
}
\examples{
x <- get_example_data()

DE_data(x[["DE"]])
}
