% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoTranslate.R
\name{autoTranslate}
\alias{autoTranslate}
\title{Attempt to automatically translate a gene list}
\usage{
autoTranslate(genes, targetGenes, possibleOrigins = NULL,
  possibleTargets = NULL, returnAllPossible = FALSE,
  db = homologene::homologeneData)
}
\arguments{
\item{genes}{A list of genes to match the target. Symbols or NCBI ids}

\item{targetGenes}{The target list. This list is supposed to represent a large number of genes
from the target species.}

\item{possibleOrigins}{Taxonomic identifiers of possible origin species}

\item{possibleTargets}{Taxonomic identifiers of possible target species}

\item{returnAllPossible}{if TRUE returns all possible pairings with non zero gene matches. If FALSE (default) returns the best match}

\item{db}{Homologene database to use.}
}
\value{
A data frame if \code{returnAllPossibe = FALSE} and a list of data frames if \code{TRUE}
}
\description{
Given a list of query gene list and a target gene list, the function
tries find the homology pairing that matches the query list to the target list. The query list
is a short list of genes while the target list is supposed to represent a large number of genes from the target
species. The default output will be the largest possible list. If \code{returnAllPossible = TRUE} then
all possible pairings with any matches are returned. It is possible to limit the
search by setting \code{possibleOrigins} and \code{possibleTargets}. Note that gene symbols of some species
are more similar to each other than others. Using this with small gene lists and without providing any
\code{possibleOrigins} or \code{possibleTargets} might return multiple hits, or if \code{returnAllPossible = TRUE}
a wrong match can be returned.
}
