% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paillier.R
\docType{class}
\name{PaillierPrivateKey}
\alias{PaillierPrivateKey}
\title{Construct a Paillier private key with the given secret and a public key}
\format{
An \code{\link[R6:R6Class]{R6::R6Class()}} generator object
}
\description{
Construct a Paillier private key with the given secret and a public key

Construct a Paillier private key with the given secret and a public key
}
\seealso{
\code{\link[=PaillierPublicKey]{PaillierPublicKey()}} which goes hand-in-hand with this object
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pubkey}}{the public key}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PaillierPrivateKey-new}{\code{PaillierPrivateKey$new()}}
\item \href{#method-PaillierPrivateKey-getLambda}{\code{PaillierPrivateKey$getLambda()}}
\item \href{#method-PaillierPrivateKey-decrypt}{\code{PaillierPrivateKey$decrypt()}}
\item \href{#method-PaillierPrivateKey-clone}{\code{PaillierPrivateKey$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPrivateKey-new"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPrivateKey-new}{}}}
\subsection{Method \code{new()}}{
Create a new private key with given secret \code{lambda} and the public key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPrivateKey$new(lambda, pubkey)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lambda}}{the secret}

\item{\code{pubkey}}{the public key}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPrivateKey-getLambda"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPrivateKey-getLambda}{}}}
\subsection{Method \code{getLambda()}}{
Return the secret lambda
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPrivateKey$getLambda()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
lambda
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPrivateKey-decrypt"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPrivateKey-decrypt}{}}}
\subsection{Method \code{decrypt()}}{
Decrypt a message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPrivateKey$decrypt(c)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c}}{the message}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the decrypted message
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPrivateKey-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPrivateKey-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPrivateKey$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
