% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nba.R
\name{load_nba_pbp}
\alias{load_nba_pbp}
\title{\strong{Load hoopR NBA play-by-play}}
\usage{
load_nba_pbp(
  seasons = most_recent_nba_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given NBA seasons. (Min: 2002)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{update_nba_db()}).}

\item{dbConnection}{A \code{DBIConnection} object, as returned by}

\item{tablename}{The name of the play by play data table within the database}
}
\value{
Returns a tibble\tabular{ll}{
   col_name \tab types \cr
   id \tab numeric \cr
   sequence_number \tab character \cr
   type_id \tab integer \cr
   type_text \tab character \cr
   text \tab character \cr
   away_score \tab integer \cr
   home_score \tab integer \cr
   period_number \tab integer \cr
   period_display_value \tab character \cr
   clock_display_value \tab character \cr
   scoring_play \tab logical \cr
   score_value \tab integer \cr
   team_id \tab integer \cr
   athlete_id_1 \tab integer \cr
   athlete_id_2 \tab integer \cr
   athlete_id_3 \tab integer \cr
   wallclock \tab character \cr
   shooting_play \tab logical \cr
   coordinate_x_raw \tab numeric \cr
   coordinate_y_raw \tab numeric \cr
   season \tab integer \cr
   season_type \tab integer \cr
   away_team_id \tab integer \cr
   away_team_name \tab character \cr
   away_team_mascot \tab character \cr
   away_team_abbrev \tab character \cr
   away_team_name_alt \tab character \cr
   home_team_id \tab integer \cr
   home_team_name \tab character \cr
   home_team_mascot \tab character \cr
   home_team_abbrev \tab character \cr
   home_team_name_alt \tab character \cr
   home_team_spread \tab numeric \cr
   game_spread \tab numeric \cr
   home_favorite \tab logical \cr
   game_spread_available \tab logical \cr
   game_id \tab integer \cr
   qtr \tab integer \cr
   time \tab character \cr
   clock_minutes \tab integer \cr
   clock_seconds \tab numeric \cr
   half \tab character \cr
   game_half \tab character \cr
   lead_qtr \tab integer \cr
   lead_game_half \tab character \cr
   start_quarter_seconds_remaining \tab integer \cr
   start_half_seconds_remaining \tab integer \cr
   start_game_seconds_remaining \tab integer \cr
   game_play_number \tab integer \cr
   end_quarter_seconds_remaining \tab integer \cr
   end_half_seconds_remaining \tab integer \cr
   end_game_seconds_remaining \tab integer \cr
   period \tab integer \cr
   lag_qtr \tab integer \cr
   lag_game_half \tab character \cr
   coordinate_x \tab numeric \cr
   coordinate_y \tab numeric \cr
   game_date \tab Date \cr
   game_date_time \tab POSIXct \cr
   type_abbreviation \tab character \cr
}
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
  load_nba_pbp(seasons = most_recent_nba_season())
}
}
\seealso{
Other hoopR Loader Functions: 
\code{\link{load_mbb_pbp}()},
\code{\link{load_mbb_player_box}()},
\code{\link{load_mbb_schedule}()},
\code{\link{load_mbb_team_box}()},
\code{\link{load_nba_player_box}()},
\code{\link{load_nba_schedule}()},
\code{\link{load_nba_team_box}()}
}
\concept{hoopR Loader Functions}
