% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nba.R
\name{load_nba_team_box}
\alias{load_nba_team_box}
\title{\strong{Load hoopR NBA team box scores}}
\usage{
load_nba_team_box(
  seasons = most_recent_nba_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given NBA seasons. (Min: 2002)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{update_nba_db()}).}

\item{dbConnection}{A \code{DBIConnection} object, as returned by}

\item{tablename}{The name of the play by play data table within the database}
}
\value{
Returns a tibble\tabular{ll}{
   col_name \tab types \cr
   game_id \tab integer \cr
   season \tab integer \cr
   season_type \tab integer \cr
   game_date \tab Date \cr
   game_date_time \tab POSIXct \cr
   team_id \tab integer \cr
   team_uid \tab character \cr
   team_slug \tab character \cr
   team_location \tab character \cr
   team_name \tab character \cr
   team_abbreviation \tab character \cr
   team_display_name \tab character \cr
   team_short_display_name \tab character \cr
   team_color \tab character \cr
   team_alternate_color \tab character \cr
   team_logo \tab character \cr
   team_home_away \tab character \cr
   team_score \tab integer \cr
   team_winner \tab logical \cr
   assists \tab integer \cr
   blocks \tab integer \cr
   defensive_rebounds \tab integer \cr
   fast_break_points \tab character \cr
   field_goal_pct \tab numeric \cr
   field_goals_made \tab integer \cr
   field_goals_attempted \tab integer \cr
   flagrant_fouls \tab integer \cr
   fouls \tab integer \cr
   free_throw_pct \tab numeric \cr
   free_throws_made \tab integer \cr
   free_throws_attempted \tab integer \cr
   largest_lead \tab character \cr
   offensive_rebounds \tab integer \cr
   points_in_paint \tab character \cr
   steals \tab integer \cr
   team_turnovers \tab integer \cr
   technical_fouls \tab integer \cr
   three_point_field_goal_pct \tab numeric \cr
   three_point_field_goals_made \tab integer \cr
   three_point_field_goals_attempted \tab integer \cr
   total_rebounds \tab integer \cr
   total_technical_fouls \tab integer \cr
   total_turnovers \tab integer \cr
   turnover_points \tab character \cr
   turnovers \tab integer \cr
   opponent_team_id \tab integer \cr
   opponent_team_uid \tab character \cr
   opponent_team_slug \tab character \cr
   opponent_team_location \tab character \cr
   opponent_team_name \tab character \cr
   opponent_team_abbreviation \tab character \cr
   opponent_team_display_name \tab character \cr
   opponent_team_short_display_name \tab character \cr
   opponent_team_color \tab character \cr
   opponent_team_alternate_color \tab character \cr
   opponent_team_logo \tab character \cr
   opponent_team_score \tab integer \cr
}
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
  load_nba_team_box(seasons = most_recent_nba_season())
}
}
\seealso{
Other hoopR Loader Functions: 
\code{\link{load_mbb_pbp}()},
\code{\link{load_mbb_player_box}()},
\code{\link{load_mbb_schedule}()},
\code{\link{load_mbb_team_box}()},
\code{\link{load_nba_pbp}()},
\code{\link{load_nba_player_box}()},
\code{\link{load_nba_schedule}()}
}
\concept{hoopR Loader Functions}
