% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_leaders.R
\name{nba_assisttracker}
\alias{nba_assisttracker}
\title{\strong{Get NBA Stats API Assist Tracker}}
\usage{
nba_assisttracker(
  league_id = "00",
  per_mode = "PerGame",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{per_mode}{Per Mode - PerGame, Totals}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: AssistTracker
}
\description{
\strong{Get NBA Stats API Assist Tracker}

\strong{Get NBA Stats API Assist Tracker}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  nba_assisttracker(league_id = '00')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Leaders Functions: 
\code{\link{nba_alltimeleadersgrids}()},
\code{\link{nba_assistleaders}()},
\code{\link{nba_defensehub}()},
\code{\link{nba_homepageleaders}()},
\code{\link{nba_homepagev2}()},
\code{\link{nba_leaderstiles}()},
\code{\link{nba_leagueleaders}()}
}
\author{
Saiem Gilani
}
\concept{NBA Leaders Functions}
