% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_league_dash.R
\name{nba_leaguedashteamptshot}
\alias{nba_leaguedashteamptshot}
\title{\strong{Get NBA Stats API League Dashboard Player Tracking - Team Shots}}
\usage{
nba_leaguedashteamptshot(
  close_def_dist_range = "",
  conference = "",
  date_from = "",
  date_to = "",
  division = "",
  dribble_range = "",
  game_segment = "",
  general_range = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  per_mode = "Totals",
  period = 0,
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  shot_dist_range = "",
  team_id = "",
  touch_time_range = "",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{close_def_dist_range}{close_def_dist_range}

\item{conference}{conference}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{division}{division}

\item{dribble_range}{dribble_range}

\item{game_segment}{game_segment}

\item{general_range}{general_range}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{per_mode}{per_mode}

\item{period}{period}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{shot_clock_range}{shot_clock_range}

\item{shot_dist_range}{shot_dist_range}

\item{team_id}{team_id}

\item{touch_time_range}{touch_time_range}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: LeagueDashPTShots

\strong{LeagueDashPTShots}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   GP \tab character \cr
   G \tab character \cr
   FGA_FREQUENCY \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   EFG_PCT \tab character \cr
   FG2A_FREQUENCY \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3A_FREQUENCY \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Dashboard Player Tracking - Team Shots}

\strong{Get NBA Stats API League Dashboard Player Tracking - Team Shots}
}
\details{
\href{https://www.nba.com/stats/teams/shots-general}{Team Shot Dashboard}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leaguedashteamptshot(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA League Functions: 
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamclutch}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_leaguegamefinder}()},
\code{\link{nba_leaguegamelog}()},
\code{\link{nba_leaguelineupviz}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_leaguestandingsv3}()},
\code{\link{nba_leaguestandings}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playoffpicture}()},
\code{\link{nba_shotchartleaguewide}()}

Other NBA Player Tracking Functions: 
\code{\link{nba_boxscoreplayertrackv2}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_synergyplaytypes}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()}

Other NBA Shooting Functions: 
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_shotchartdetail}()},
\code{\link{nba_shotchartleaguewide}()},
\code{\link{nba_shotchartlineupdetail}()},
\code{\link{nba_teamdashboardbyshootingsplits}()}
}
\author{
Saiem Gilani
}
\concept{NBA League Functions}
\concept{NBA Player Tracking Functions}
\concept{NBA Shooting Functions}
