% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_league.R
\name{nba_leaguegamelog}
\alias{nba_leaguegamelog}
\title{\strong{Get NBA Stats API League Game Log}}
\usage{
nba_leaguegamelog(
  counter = 0,
  date_from = "",
  date_to = "",
  direction = "ASC",
  league_id = "00",
  player_or_team = "T",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  sorter = "DATE",
  ...
)
}
\arguments{
\item{counter}{counter}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{direction}{direction}

\item{league_id}{league_id}

\item{player_or_team}{player_or_team}

\item{season}{season}

\item{season_type}{season_type}

\item{sorter}{sorter}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: LeagueGameLog

\strong{LeagueGameLog}\tabular{ll}{
   col_name \tab types \cr
   SEASON_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   GAME_ID \tab character \cr
   GAME_DATE \tab character \cr
   MATCHUP \tab character \cr
   WL \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   VIDEO_AVAILABLE \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Game Log}

\strong{Get NBA Stats API League Game Log}
}
\details{
\href{https://www.nba.com/stats/players/boxscores}{Player/Team Boxscores}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leaguegamelog(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA League Functions: 
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamclutch}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_leaguegamefinder}()},
\code{\link{nba_leaguelineupviz}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_leaguestandingsv3}()},
\code{\link{nba_leaguestandings}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playoffpicture}()},
\code{\link{nba_shotchartleaguewide}()}
}
\author{
Saiem Gilani
}
\concept{NBA League Functions}
