% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_league.R
\name{nba_leaguestandings}
\alias{nba_leaguestandings}
\title{\strong{Get NBA Stats API League Standings}}
\usage{
nba_leaguestandings(
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  season_year = "",
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{season}{season}

\item{season_type}{season_type}

\item{season_year}{season_year}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: Standings

\strong{Standings}\tabular{ll}{
   col_name \tab types \cr
   LeagueID \tab character \cr
   SeasonID \tab character \cr
   TeamID \tab character \cr
   TeamCity \tab character \cr
   TeamName \tab character \cr
   Conference \tab character \cr
   ConferenceRecord \tab character \cr
   PlayoffRank \tab character \cr
   ClinchIndicator \tab character \cr
   Division \tab character \cr
   DivisionRecord \tab character \cr
   DivisionRank \tab character \cr
   WINS \tab character \cr
   LOSSES \tab character \cr
   WinPCT \tab character \cr
   LeagueRank \tab character \cr
   Record \tab character \cr
   HOME \tab character \cr
   ROAD \tab character \cr
   L10 \tab character \cr
   Last10Home \tab character \cr
   Last10Road \tab character \cr
   OT \tab character \cr
   ThreePTSOrLess \tab character \cr
   TenPTSOrMore \tab character \cr
   LongHomeStreak \tab character \cr
   strLongHomeStreak \tab character \cr
   LongRoadStreak \tab character \cr
   strLongRoadStreak \tab character \cr
   LongWinStreak \tab character \cr
   LongLossStreak \tab character \cr
   CurrentHomeStreak \tab character \cr
   strCurrentHomeStreak \tab character \cr
   CurrentRoadStreak \tab character \cr
   strCurrentRoadStreak \tab character \cr
   CurrentStreak \tab character \cr
   strCurrentStreak \tab character \cr
   ConferenceGamesBack \tab character \cr
   DivisionGamesBack \tab character \cr
   ClinchedConferenceTitle \tab character \cr
   ClinchedDivisionTitle \tab character \cr
   ClinchedPlayoffBirth \tab character \cr
   EliminatedConference \tab character \cr
   EliminatedDivision \tab character \cr
   AheadAtHalf \tab character \cr
   BehindAtHalf \tab character \cr
   TiedAtHalf \tab character \cr
   AheadAtThird \tab character \cr
   BehindAtThird \tab character \cr
   TiedAtThird \tab character \cr
   Score100PTS \tab character \cr
   OppScore100PTS \tab character \cr
   OppOver500 \tab character \cr
   LeadInFGPCT \tab character \cr
   LeadInReb \tab character \cr
   FewerTurnovers \tab character \cr
   PointsPG \tab character \cr
   OppPointsPG \tab character \cr
   DiffPointsPG \tab character \cr
   vsEast \tab character \cr
   vsAtlantic \tab character \cr
   vsCentral \tab character \cr
   vsSoutheast \tab character \cr
   vsWest \tab character \cr
   vsNorthwest \tab character \cr
   vsPacific \tab character \cr
   vsSouthwest \tab character \cr
   Jan \tab character \cr
   Feb \tab character \cr
   Mar \tab character \cr
   Apr \tab character \cr
   May \tab character \cr
   Jun \tab character \cr
   Jul \tab character \cr
   Aug \tab character \cr
   Sep \tab character \cr
   Oct \tab character \cr
   Nov \tab character \cr
   Dec \tab character \cr
   PreAS \tab character \cr
   PostAS \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Standings}

\strong{Get NBA Stats API League Standings}
}
\details{
\href{https://www.nba.com/standings}{League Standings}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leaguestandings(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA League Functions: 
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamclutch}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_leaguegamefinder}()},
\code{\link{nba_leaguegamelog}()},
\code{\link{nba_leaguelineupviz}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_leaguestandingsv3}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playoffpicture}()},
\code{\link{nba_shotchartleaguewide}()}
}
\author{
Saiem Gilani
}
\concept{NBA League Functions}
