% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_team_dash.R
\name{nba_teamdashptreb}
\alias{nba_teamdashptreb}
\title{\strong{Get NBA Stats API Team Dashboard Player Tracking - Rebounding}}
\usage{
nba_teamdashptreb(
  date_from = "",
  date_to = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  per_mode = "Totals",
  period = 0,
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  team_id = "1610612749",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{per_mode}{per_mode}

\item{period}{period}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: NumContestedRebounding, OverallRebounding,
RebDistanceRebounding, ShotDistanceRebounding, ShotTypeRebounding

\strong{OverallRebounding}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   G \tab character \cr
   OVERALL \tab character \cr
   REB_FREQUENCY \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   C_OREB \tab character \cr
   C_DREB \tab character \cr
   C_REB \tab character \cr
   C_REB_PCT \tab character \cr
   UC_OREB \tab character \cr
   UC_DREB \tab character \cr
   UC_REB \tab character \cr
   UC_REB_PCT \tab character \cr
}


\strong{ShotTypeRebounding}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   SHOT_TYPE_RANGE \tab character \cr
   REB_FREQUENCY \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   C_OREB \tab character \cr
   C_DREB \tab character \cr
   C_REB \tab character \cr
   C_REB_PCT \tab character \cr
   UC_OREB \tab character \cr
   UC_DREB \tab character \cr
   UC_REB \tab character \cr
   UC_REB_PCT \tab character \cr
}


\strong{NumContestedRebounding}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   REB_NUM_CONTESTING_RANGE \tab character \cr
   REB_FREQUENCY \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   C_OREB \tab character \cr
   C_DREB \tab character \cr
   C_REB \tab character \cr
   C_REB_PCT \tab character \cr
   UC_OREB \tab character \cr
   UC_DREB \tab character \cr
   UC_REB \tab character \cr
   UC_REB_PCT \tab character \cr
}


\strong{ShotDistanceRebounding}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   SHOT_DIST_RANGE \tab character \cr
   REB_FREQUENCY \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   C_OREB \tab character \cr
   C_DREB \tab character \cr
   C_REB \tab character \cr
   C_REB_PCT \tab character \cr
   UC_OREB \tab character \cr
   UC_DREB \tab character \cr
   UC_REB \tab character \cr
   UC_REB_PCT \tab character \cr
}


\strong{RebDistanceRebounding}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   REB_DIST_RANGE \tab character \cr
   REB_FREQUENCY \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   C_OREB \tab character \cr
   C_DREB \tab character \cr
   C_REB \tab character \cr
   C_REB_PCT \tab character \cr
   UC_OREB \tab character \cr
   UC_DREB \tab character \cr
   UC_REB \tab character \cr
   UC_REB_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Dashboard Player Tracking - Rebounding}

\strong{Get NBA Stats API Team Dashboard Player Tracking - Rebounding}
}
\details{
\href{https://www.nba.com/stats/team/1610612749/rebounds-dash}{Team Player Tracking (Second Spectrum) Stats - Rebounds}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_teamdashptreb(team_id = '1610612749', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Team Functions: 
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_teamdashboardbyclutch}()},
\code{\link{nba_teamdashboardbygamesplits}()},
\code{\link{nba_teamdashboardbygeneralsplits}()},
\code{\link{nba_teamdashboardbylastngames}()},
\code{\link{nba_teamdashboardbyopponent}()},
\code{\link{nba_teamdashboardbyshootingsplits}()},
\code{\link{nba_teamdashboardbyteamperformance}()},
\code{\link{nba_teamdashboardbyyearoveryear}()},
\code{\link{nba_teamdashlineups}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptshots}()},
\code{\link{nba_teamdetails}()},
\code{\link{nba_teamestimatedmetrics}()},
\code{\link{nba_teamgamelogs}()},
\code{\link{nba_teamgamelog}()},
\code{\link{nba_teamgamestreakfinder}()},
\code{\link{nba_teamhistoricalleaders}()},
\code{\link{nba_teaminfocommon}()},
\code{\link{nba_teamplayerdashboard}()},
\code{\link{nba_teamplayeronoffdetails}()},
\code{\link{nba_teamplayeronoffsummary}()},
\code{\link{nba_teams}()},
\code{\link{nba_teamvsplayer}()},
\code{\link{nba_teamyearbyyearstats}()}

Other NBA Player Tracking Functions: 
\code{\link{nba_boxscoreplayertrackv2}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_synergyplaytypes}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptshots}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Tracking Functions}
\concept{NBA Team Functions}
