% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_team.R
\name{nba_teamgamelog}
\alias{nba_teamgamelog}
\title{\strong{Get NBA Stats API Team Game Log}}
\usage{
nba_teamgamelog(
  date_from = "",
  date_to = "",
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  team_id = "1610612749",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{team_id}{Team ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: TeamGameLog

\strong{TeamGameLog}\tabular{ll}{
   col_name \tab types \cr
   Team_ID \tab character \cr
   Game_ID \tab character \cr
   GAME_DATE \tab character \cr
   MATCHUP \tab character \cr
   WL \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Game Log}

\strong{Get NBA Stats API Team Game Log}
}
\details{
\href{https://www.nba.com/stats/team/1610612749/boxscores}{Teams Game Log}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_teamgamelog(team_id = '1610612749')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Team Functions: 
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_teamdashboardbyclutch}()},
\code{\link{nba_teamdashboardbygamesplits}()},
\code{\link{nba_teamdashboardbygeneralsplits}()},
\code{\link{nba_teamdashboardbylastngames}()},
\code{\link{nba_teamdashboardbyopponent}()},
\code{\link{nba_teamdashboardbyshootingsplits}()},
\code{\link{nba_teamdashboardbyteamperformance}()},
\code{\link{nba_teamdashboardbyyearoveryear}()},
\code{\link{nba_teamdashlineups}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()},
\code{\link{nba_teamdetails}()},
\code{\link{nba_teamestimatedmetrics}()},
\code{\link{nba_teamgamelogs}()},
\code{\link{nba_teamgamestreakfinder}()},
\code{\link{nba_teamhistoricalleaders}()},
\code{\link{nba_teaminfocommon}()},
\code{\link{nba_teamplayerdashboard}()},
\code{\link{nba_teamplayeronoffdetails}()},
\code{\link{nba_teamplayeronoffsummary}()},
\code{\link{nba_teams}()},
\code{\link{nba_teamvsplayer}()},
\code{\link{nba_teamyearbyyearstats}()}
}
\author{
Saiem Gilani
}
\concept{NBA Team Functions}
