test_that("NBA Live Boxscore", {
  skip_on_cran()
  skip_on_ci()

  x <- nba_live_boxscore(game_id = "0022201086")

  cols_x1 <- c(
    "game_id",
    "game_time_local",
    "game_time_utc",
    "game_time_home",
    "game_time_away",
    "game_et",
    "duration",
    "game_code",
    "game_status_text",
    "game_status",
    "regulation_periods",
    "period",
    "game_clock",
    "attendance",
    "sellout",
    "home_team_id",
    "home_team_name",
    "home_team_city",
    "home_team_tricode",
    "home_team_score",
    "home_team_in_bonus",
    "home_team_timeouts_remaining",
    "away_team_id",
    "away_team_name",
    "away_team_city",
    "away_team_tricode",
    "away_team_score",
    "away_team_in_bonus",
    "away_team_timeouts_remaining"
  )

  cols_x2 <- c(
    "arena_id",
    "arena_name",
    "arena_city",
    "arena_state",
    "arena_country",
    "arena_timezone"
  )

  cols_x3 <- c(
    "person_id",
    "name",
    "name_i",
    "first_name",
    "family_name",
    "jersey_num",
    "assignment"
  )

  cols_x4 <- c(
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_score",
    "team_in_bonus",
    "team_timeouts_remaining",
    "assists",
    "assists_turnover_ratio",
    "bench_points",
    "biggest_lead",
    "biggest_lead_score",
    "biggest_scoring_run",
    "biggest_scoring_run_score",
    "blocks",
    "blocks_received",
    "fast_break_points_attempted",
    "fast_break_points_made",
    "fast_break_points_percentage",
    "field_goals_attempted",
    "field_goals_effective_adjusted",
    "field_goals_made",
    "field_goals_percentage",
    "fouls_offensive",
    "fouls_drawn",
    "fouls_personal",
    "fouls_team",
    "fouls_technical",
    "fouls_team_technical",
    "free_throws_attempted",
    "free_throws_made",
    "free_throws_percentage",
    "lead_changes",
    "minutes",
    "minutes_calculated",
    "points",
    "points_against",
    "points_fast_break",
    "points_from_turnovers",
    "points_in_the_paint",
    "points_in_the_paint_attempted",
    "points_in_the_paint_made",
    "points_in_the_paint_percentage",
    "points_second_chance",
    "rebounds_defensive",
    "rebounds_offensive",
    "rebounds_personal",
    "rebounds_team",
    "rebounds_team_defensive",
    "rebounds_team_offensive",
    "rebounds_total",
    "second_chance_points_attempted",
    "second_chance_points_made",
    "second_chance_points_percentage",
    "steals",
    "three_pointers_attempted",
    "three_pointers_made",
    "three_pointers_percentage",
    "time_leading",
    "times_tied",
    "true_shooting_attempts",
    "true_shooting_percentage",
    "turnovers",
    "turnovers_team",
    "turnovers_total",
    "two_pointers_attempted",
    "two_pointers_made",
    "two_pointers_percentage"
  )

  cols_x5 <- c(
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_score",
    "team_in_bonus",
    "team_timeouts_remaining",
    "assists",
    "assists_turnover_ratio",
    "bench_points",
    "biggest_lead",
    "biggest_lead_score",
    "biggest_scoring_run",
    "biggest_scoring_run_score",
    "blocks",
    "blocks_received",
    "fast_break_points_attempted",
    "fast_break_points_made",
    "fast_break_points_percentage",
    "field_goals_attempted",
    "field_goals_effective_adjusted",
    "field_goals_made",
    "field_goals_percentage",
    "fouls_offensive",
    "fouls_drawn",
    "fouls_personal",
    "fouls_team",
    "fouls_technical",
    "fouls_team_technical",
    "free_throws_attempted",
    "free_throws_made",
    "free_throws_percentage",
    "lead_changes",
    "minutes",
    "minutes_calculated",
    "points",
    "points_against",
    "points_fast_break",
    "points_from_turnovers",
    "points_in_the_paint",
    "points_in_the_paint_attempted",
    "points_in_the_paint_made",
    "points_in_the_paint_percentage",
    "points_second_chance",
    "rebounds_defensive",
    "rebounds_offensive",
    "rebounds_personal",
    "rebounds_team",
    "rebounds_team_defensive",
    "rebounds_team_offensive",
    "rebounds_total",
    "second_chance_points_attempted",
    "second_chance_points_made",
    "second_chance_points_percentage",
    "steals",
    "three_pointers_attempted",
    "three_pointers_made",
    "three_pointers_percentage",
    "time_leading",
    "times_tied",
    "true_shooting_attempts",
    "true_shooting_percentage",
    "turnovers",
    "turnovers_team",
    "turnovers_total",
    "two_pointers_attempted",
    "two_pointers_made",
    "two_pointers_percentage"
  )

  cols_x6 <- c(
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_score",
    "team_in_bonus",
    "team_timeouts_remaining",
    "status",
    "order",
    "person_id",
    "jersey_num",
    "position",
    "starter",
    "oncourt",
    "played",
    "assists",
    "blocks",
    "blocks_received",
    "field_goals_attempted",
    "field_goals_made",
    "field_goals_percentage",
    "fouls_offensive",
    "fouls_drawn",
    "fouls_personal",
    "fouls_technical",
    "free_throws_attempted",
    "free_throws_made",
    "free_throws_percentage",
    "minus",
    "minutes",
    "minutes_calculated",
    "plus",
    "plus_minus_points",
    "points",
    "points_fast_break",
    "points_in_the_paint",
    "points_second_chance",
    "rebounds_defensive",
    "rebounds_offensive",
    "rebounds_total",
    "steals",
    "three_pointers_attempted",
    "three_pointers_made",
    "three_pointers_percentage",
    "turnovers",
    "two_pointers_attempted",
    "two_pointers_made",
    "two_pointers_percentage",
    "name",
    "name_i",
    "first_name",
    "family_name",
    "not_playing_reason",
    "not_playing_description"
  )

  cols_x7 <- c(
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_score",
    "team_in_bonus",
    "team_timeouts_remaining",
    "status",
    "order",
    "person_id",
    "jersey_num",
    "position",
    "starter",
    "oncourt",
    "played",
    "assists",
    "blocks",
    "blocks_received",
    "field_goals_attempted",
    "field_goals_made",
    "field_goals_percentage",
    "fouls_offensive",
    "fouls_drawn",
    "fouls_personal",
    "fouls_technical",
    "free_throws_attempted",
    "free_throws_made",
    "free_throws_percentage",
    "minus",
    "minutes",
    "minutes_calculated",
    "plus",
    "plus_minus_points",
    "points",
    "points_fast_break",
    "points_in_the_paint",
    "points_second_chance",
    "rebounds_defensive",
    "rebounds_offensive",
    "rebounds_total",
    "steals",
    "three_pointers_attempted",
    "three_pointers_made",
    "three_pointers_percentage",
    "turnovers",
    "two_pointers_attempted",
    "two_pointers_made",
    "two_pointers_percentage",
    "name",
    "name_i",
    "first_name",
    "family_name",
    "not_playing_reason",
    "not_playing_description"
  )

  cols_x8 <- c(
    "period",
    "period_type",
    "score"
  )

  cols_x9 <- c(
    "period",
    "period_type",
    "score"
  )

  expect_equal(sort(colnames(x[[1]])), sort(cols_x1))
  expect_s3_class(x[[1]], "data.frame")
  expect_equal(sort(colnames(x[[2]])), sort(cols_x2))
  expect_s3_class(x[[2]], "data.frame")
  expect_equal(sort(colnames(x[[3]])), sort(cols_x3))
  expect_s3_class(x[[3]], "data.frame")
  expect_equal(sort(colnames(x[[4]])), sort(cols_x4))
  expect_s3_class(x[[4]], "data.frame")
  expect_equal(sort(colnames(x[[5]])), sort(cols_x5))
  expect_s3_class(x[[5]], "data.frame")
  expect_equal(sort(colnames(x[[6]])), sort(cols_x6))
  expect_s3_class(x[[6]], "data.frame")
  expect_equal(sort(colnames(x[[7]])), sort(cols_x7))
  expect_s3_class(x[[7]], "data.frame")
  expect_equal(sort(colnames(x[[8]])), sort(cols_x8))
  expect_s3_class(x[[8]], "data.frame")
  expect_equal(sort(colnames(x[[9]])), sort(cols_x9))
  expect_s3_class(x[[9]], "data.frame")

  Sys.sleep(3)

})
