% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sound.R
\name{playSound}
\alias{playSound}
\title{Play Sound}
\usage{
playSound(track, options = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{track}{Either a URL, file path or Base 64 character string of the
sound to play}

\item{options}{A named list of options to add to the sound. For a full list of options see
\url{https://github.com/goldfire/howler.js?tab=readme-ov-file#options}}

\item{session}{Shiny session}
}
\description{
Using howler.js, play a sound within a shiny application.
}
\details{
The `src` and `autoplay` options are pre-determined by `playSound` and are not required
in `options`. If they are included, a warning will be printed and they will be ignored
from the list.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)

audio_files_dir <- system.file("examples/_audio", package = "howler")
addResourcePath("sample_audio", audio_files_dir)

ui <- fluidPage(
  actionButton("play", "Play Sound")
)

server <- function(input, output) {
  observeEvent(input$play, {
    playSound("sample_audio/running_out.mp3")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
