% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regimes.R
\name{regimes}
\alias{regimes}
\title{Estimation of regimes models}
\usage{
regimes(formula, data, rgv = NULL, vc = c("homoskedastic", "groupwise"))
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x_f | x_v} where \code{y} is the dependent variable, \code{x_f} are the regressors that do not vary by regimes and  \code{x_v} are the regressors that vary by regimes}

\item{data}{the data of class \code{data.frame}.}

\item{rgv}{an object of class \code{formula} to identify the regime variables}

\item{vc}{one of \code{c("homoskedastic", "groupwise")}. If \code{groupwise}, the model VC matrix is estimated by weighted least square.}
}
\value{
An object of class \code{lm} and \code{spregimes}.
}
\description{
The function \code{regimes} deals with
the estimation of regime models.
Most of the times the variable identifying the regimes
reveals some spatial aspects of the data (e.g., administrative boundaries).
}
\details{
For convenience and without loss of generality,
we assume the presence of only two regimes.
In this case,
the basic (non-spatial) is:
\deqn{
y
=
\begin{bmatrix}
X_1& 0 \\
0 & X_2 \\
\end{bmatrix}
\begin{bmatrix}
\beta_1 \\
\beta_2 \\
\end{bmatrix}
+ X\beta +
\varepsilon
}
where  \eqn{y = [y_1^\prime,y_2^\prime]^\prime},
and the \eqn{n_1 \times 1} vector \eqn{y_1} contains the observations
on the dependent variable for the first regime,
and the \eqn{n_2 \times 1} vector \eqn{y_2} (with \eqn{n_1 + n_2 = n})
contains the observations on the dependent variable for the second regime.
The \eqn{n_1 \times k} matrix \eqn{X_1} and the \eqn{n_2 \times k}
matrix \eqn{X_2} are blocks of a block diagonal matrix,
the vectors of parameters  \eqn{\beta_1} and \eqn{\beta_2} have
dimension \eqn{k_1 \times 1} and \eqn{k_2 \times 1}, respectively,
\eqn{X} is the \eqn{n \times p} matrix of regressors that do not vary by regime,
\eqn{\beta}  is a \eqn{p\times 1} vector of parameters
and \eqn{\varepsilon = [\varepsilon_1^\prime,\varepsilon_2^\prime]^\prime}
is the \eqn{n\times 1} vector of innovations.
\itemize{
\item If \code{vc = "homoskedastic"}, the model is estimated by OLS.
\item If \code{vc = "groupwise"}, the model is estimated in two steps.
In the first step, the model is estimated by OLS. In the second step, the
inverse of the (groupwise) residuals from the first step are employed
as weights in a  weighted least square procedure.}
}
\examples{
data("baltim")
form   <- PRICE  ~ NROOM + NBATH + PATIO + FIREPL + AC + GAR + AGE + LOTSZ + SQFT
split  <- ~ CITCOU
mod <- regimes(formula = form, data = baltim, rgv = split, vc = "groupwise")
summary(mod)
form <- PRICE  ~ AC + AGE + NROOM + PATIO + FIREPL + SQFT | NBATH + GAR + LOTSZ - 1
mod <- regimes(form, baltim, split, vc = "homoskedastic")
summary(mod)


}
\author{
Gianfranco Piras and Mauricio Sarrias
}
