% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{format_reverse}
\alias{format_reverse}
\title{Reformat Reversed Names}
\usage{
format_reverse(names)
}
\arguments{
\item{names}{a vector of names following this convention. Names that lack commas will
be returned entirely intact, so assuming you don't have (legitimate) commas in names
not following this format, there's no need to worry if your vector has mixed formatting.}
}
\value{
a vector containing the reformatted names
}
\description{
a common pattern for names is 'Lastname Suffix, Salutation Firstname' -
or to put that more practically, 'Jeffries PhD, Mr Bernard'. \code{format_reverse}
takes these reversed names and reformats them to a form that \code{\link{parse_names}}
can handle.
}
\examples{

# Take a reversed name and un-reverse it
format_reverse("Keyes, Oliver")

}
\seealso{
\code{\link{parse_names}}, which works more reliably if reversed names have
been reformatted, and \code{\link{format_period}} for period-separated names.
}

