% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_poisson.R
\name{zero_poisson}
\alias{zero_poisson}
\title{Zero-Inflated Poisson Regression Model}
\usage{
zero_poisson(y, x, a = 1, b = 1, lam.start = 1, beta.prior.mean = 0,
  beta.prior.sd = 1, iters = 1000, burn = 500, nthin = 1, plots = T,
  progress.bar = T)
}
\arguments{
\item{y}{numeric response vector.}

\item{x}{numeric predictor matrix.}

\item{a}{shape parameter for gamma prior distributions.}

\item{b}{rate parameter for gamma prior distributions.}

\item{lam.start}{initial value for lambda parameter.}

\item{beta.prior.mean}{mu parameter for normal prior distributions.}

\item{beta.prior.sd}{standard deviation for normal prior distributions.}

\item{iters}{number of iterations for the Markov chain to run.}

\item{burn}{numeric burn-in length.}

\item{nthin}{numeric thinning rate.}

\item{plots}{logical operator. \code{TRUE} to output plots.}

\item{progress.bar}{logical operator. \code{TRUE} to print progress bar.}
}
\value{
\code{zero_poisson} returns a list which includes the items
\describe{
   \item{lam}{numeric vector; posterior distribution of lambda parameter}
   \item{beta}{numeric matrix; posterior distributions of regression coefficients}
   \item{p}{numeric vector; posterior distribution of parameter 'p', the 
   probability of a given zero observation belonging to the model's zero component}
   \item{ll}{numeric vector; posterior log-likelihood}    
}
}
\description{
\code{zero_poisson} is used to fit zero-inflated 
poisson regression models to count data via Bayesian inference.
}
\details{
Fits a zero-inflated Poisson (ZIP) model.
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
