% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg.R
\name{gsegmat_symb}
\alias{gsegmat_symb}
\title{Symbolic representation of the segregation probability matrix}
\usage{
gsegmat_symb(ploidy, out = c("str", "exp"))
}
\arguments{
\item{ploidy}{The ploidy of the species}

\item{out}{Should we return a character matrix
(\code{"str"}) or an expression matrix (\code{"exp"})?}
}
\value{
A character or expression matrix containing the mathematical
form for the segregation matrix. Element (i, j) is the probability
a parent with dosage i-1 produces a gamete with dosage j-1.
}
\description{
Two alleles are identical-by-double-reduction (IBDR) if they originate from
the same (by origin) allele in the parent. We let "a" be the probability of
zero IBDR alleles, "b" be the probability of one IBDR pair,
"c" be the probability of two IBDR pairs, etc...
}
\examples{
gsegmat_symb(4)
gsegmat_symb(6)
gsegmat_symb(8)
}
\seealso{
\code{\link{gsegmat}()} for numerical expressions.
}
\author{
David Gerard
}
