% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{fit.hydroState}
\alias{fit.hydroState}
\title{Fit hydroState model}
\usage{
fit.hydroState(
  model,
  pop.size.perParameter = 10,
  max.generations = 500,
  doParallel = FALSE,
  ...
)
}
\arguments{
\item{model}{built hydroState model object, hydroState.allModels object, or hydroState.subAnnual.allModels object}

\item{pop.size.perParameter}{integer that should be greater than or equal to the number of parameters in the model. The default is '10' and is sufficient for all models.}

\item{max.generations}{integer that will stop the optimizer when set number of generations are reached. The default is '500'.}

\item{doParallel}{TRUE/FALSE to perform fitting in parallel on all computer cores. Default is FALSE}

\item{...}{additional options to change the optimization settings: reltol, print.iterations, etc. from the \href{https://cran.r-project.org/package=DEoptim}{DEoptim} library}
}
\value{
A fitted hydroState model
}
\description{
\code{fit.hydroState} fits a single hydroState model (\code{build}) or multiple models (\code{build.all}) using global optimization by differential evolution \href{https://cran.r-project.org/package=DEoptim}{DEoptim} library. If fitting all models be sure to install and load the \href{https://cran.r-project.org/package=parallelly}{parallelly} library. The fitting of all models may take hours or days, but the calibration can occur in parallel if the \href{https://cran.r-project.org/package=parallelly}{parallelly} library is installed and loaded.
}
\details{
\code{fit.hydroState}

After a hydroState model object is built, the model is ready to fit to the observed streamflow through minimizing the negative log-likelihood function too calibrate model parameters. The only required input is the given built hydroState model object or hydroState.allModels object (all models from \code{build.all = TRUE}). When fitting all models, the models are fitted from least to most complex (least to max amount of parameters). Each model has a minimum of 5 and maximum of 20 calibration attempts to outperform the prior reference model else the model is rejected. For instance 'model.1State.normal.log.AR0' contains 3-parameters and is the reference model for 'model.1State.normal.log.AR1' which contains 4-parameters. The objective function of 'model.1State.normal.log.AR1' must calibrate the model with a lower negative log-likelihood than 'model.1State.normal.log.AR0'. These reference models are pre-defined, but this function allows the user to edit the reference models in the data.frame if needed using \code{summary}. Details on the likelihood function is as follows:

The likelihood function is estimated as:

\eqn{L_{T} = \delta P(x_{1}) + \Gamma \delta P(x_{2})...\Gamma \delta P(x_{T})1'}

where:
\itemize{
\item{\eqn{\delta} is the initial state distribution, the initial probability of being in each state: \eqn{\delta = \begin{pmatrix} \delta_{1} \\ 1- \delta_{1} \end{pmatrix}}}
\item{\eqn{P(x)} is the \eqn{m} x \eqn{m} diagonal emissions matrix of the probability density for each state using a lower tail truncated Gaussian distribution or a two-parameter Gamma distribution:
\itemize{
\item{\eqn{f_{Gau}(x=\hat{_{obs}q_{t}}; \mu = \hat{_{t}q_{i}}, \sigma = \sigma_{i}, a = 0) = \frac{\phi(\frac{x-\mu}{\sigma})}{\sigma(1-\Phi(\frac{a-\mu}{\sigma}))}}}
\item{\eqn{f_{Gam}(x = \hat{_{obs}q_{t}}; k = \frac{\hat{_{t}q_{i}}^2}{\sigma_{i}^2}, \theta = \frac{\sigma_{i}^2}{\hat{_{t}q_{i}}}) = \frac{x^{k-1}e^{\frac{x}{\theta}}}{\theta^{k}\Gamma(k)}}}
\item{where \eqn{\phi} is the probability density function for the standard normal distribution, \eqn{\Phi} is the cumulative distribution function for the standard normal distribution, \eqn{k} is the shape parameter, \eqn{\theta} is the scale parameter, and \eqn{\Gamma(k)} is the gamma function. For more details, refer to pg. 8–17 in Supplementary Materials of (Peterson TJ, Saft M, Peel MC & John A (2021), Watersheds may not recover from drought, Science, DOI: \doi{10.1126/science.abd5085}).}
}
}
\item{\eqn{\Gamma} is the transition matrix}
\item{\eqn{T} is the number of time-steps.}
}
}
\examples{

# Load data
data(streamflow_annual_221201)

## Build default annual hydroState model
model = build(input.data = streamflow_annual_221201)

## Fit built model (runtime ~ 14 sec)
\donttest{
model = fit.hydroState(model)
}

## Fit all built models (runtime > several hours)
# Load data
data(streamflow_annual_221201)

## Build all annual models
all.annual.models = build.all(input.data = streamflow_annual_221201, siteID = '221201')

# Fit all (runtime > several hours)
\donttest{
all.annual.models = fit.hydroState(all.annual.models)
}

}
\keyword{fit}
\keyword{hydroState}
