% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_year_DGI.R
\name{hydro_year_DGI}
\alias{hydro_year_DGI}
\title{Hydrological year classification}
\usage{
hydro_year_DGI(df)
}
\arguments{
\item{df}{a data frame with total annual volumes discharges created with \link{agg_serie} function.}
}
\value{
A data frame containing the hydrological classification for each year.
}
\description{
This function allows you to get the hydrological year. The criteria is consistent with the one of \href{http://www.irrigacion.gov.ar/dgi/}{Departamento General de Irrigacion} (Mendoza - Argentina).
}
\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# List with meteorological variables (slots in BDHI's object)
cargar <- list('precip', 'Qmd', 'Qmm')

# Now assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Guido' )
names(cargar) <- hydro_files

# Build the object with the met records
guido <- build_hydroMet(obj = guido, slot_list = cargar, 
               path = system.file('extdata', package = "hydroToolkit") )
               
# Now get mean monthly discharge
Qmm <- get_hydroMet(obj = guido, name = 'Qmm')[[1]]

# Get the monthly water volume
Qmm_vol <- Qmm_to_Dm(df = Qmm)

# Aggregate data frame to get total annual discharges
AD  <- agg_serie(df = Qmm_vol, fun = 'sum', period = 'annual', out_name = 'Ann_vol',
         start_month = 7, end_month = 6, allow_NA = 2)
         
# Get hydrological year classification
AD_class <- hydro_year_DGI(df = AD)
               
}
