% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_subset_hydroMet.R
\name{subset_hydroMet}
\alias{subset_hydroMet}
\alias{subset_hydroMet,hydroMet_BDHI-method}
\alias{subset_hydroMet,hydroMet_DGI-method}
\alias{subset_hydroMet,hydroMet_CR2-method}
\alias{subset_hydroMet,hydroMet_IANIGLA-method}
\alias{subset_hydroMet,hydroMet_compact-method}
\title{Subset your data}
\usage{
subset_hydroMet(obj, slot_name, from = NULL, to = NULL)

\S4method{subset_hydroMet}{hydroMet_BDHI}(obj, slot_name, from = NULL, to = NULL)

\S4method{subset_hydroMet}{hydroMet_DGI}(obj, slot_name, from = NULL, to = NULL)

\S4method{subset_hydroMet}{hydroMet_CR2}(obj, slot_name, from = NULL, to = NULL)

\S4method{subset_hydroMet}{hydroMet_IANIGLA}(obj, slot_name, from = NULL, to = NULL)

\S4method{subset_hydroMet}{hydroMet_compact}(obj, slot_name, from = NULL, to = NULL)
}
\arguments{
\item{obj}{an \code{hydroMet_XXX} class object.}

\item{slot_name}{string vector with the slot(s) name(s) to subset. \strong{NOTE}: in case you want to subset a \code{hydroMet_IANIGLA} object is recommended to consider all the slots with data.}

\item{from}{string (or \code{POSIXct} - valid only in 'BDHI' and  'IANIGLA') with the starting \code{Date}. You can use \code{from} without \code{to}. In this case you will subset your data 'from' till the end.}

\item{to}{string (or \code{POSIXct} - valid only in 'BDHI' and  'IANIGLA') with the ending \code{Date}. You can use \code{to} without \code{from}. In this case you will subset your data from the beginning till 'to'.}
}
\value{
The same \code{hydroMet_XXX} class provided in \code{obj} but subsetted.
}
\description{
This method allows you to easily cut the data stored in an \code{hydroMet_XXX} class object by dates.
}
\section{Functions}{
\itemize{
\item \code{subset_hydroMet,hydroMet_BDHI-method}: subset method for BDHI data

\item \code{subset_hydroMet,hydroMet_DGI-method}: subset method for DGI data

\item \code{subset_hydroMet,hydroMet_CR2-method}: subset method for CR2 data

\item \code{subset_hydroMet,hydroMet_IANIGLA-method}: subset method for IANIGLA data

\item \code{subset_hydroMet,hydroMet_compact-method}: subset method for \code{compact} data
}}

\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# List with meteorological variables (slots in BDHI's object)
cargar <- list('precip', 'Qmd', 'Qmm')

# Assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Guido' )
names(cargar) <- hydro_files

# Build the object with the met records
guido <- build_hydroMet(obj = guido, slot_list = cargar, 
               path = system.file('extdata', package = "hydroToolkit") )
               
# Subset daily mean discharge
guido <- subset_hydroMet(obj = guido, slot_name = 'Qmd', from = '2005-01-01',
            to = '2010-12-31')

}
