% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{as.data.frame.Cube}
\alias{as.data.frame.Cube}
\title{Converts the actual view of a cube to a data frame}
\usage{
\method{as.data.frame}{Cube}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{The \code{Cube} object that will be converted to a data frame.}

\item{row.names}{A character vector giving the row names for the data frame.}

\item{optional}{Should setting row names and converting column names be optional?}

\item{...}{Further parameters that are passed to \code{\link{as.data.frame.table}}.}
}
\value{
A molten data frame
}
\description{
Converts the actual view of a \code{Cube} object to a data frame. All added selections and
aggregations will be regarded. Note that selection criteria will be applied before
aggregating the data.
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
cube = change.dimensionOrder(cube, dimensions = c("product", "month", "year", "state"))
df = as.data.frame(cube)
df

}
\seealso{
\code{\link{add.aggregation}} \code{\link{add.selection}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}
}
