% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognorm_errorI.R
\name{lognorm_errorI}
\alias{lognorm_errorI}
\title{Empirical Error Type I Associated with a Log Normal Distribution}
\usage{
lognorm_errorI(c, n = 150, theta0 = 0, sdlog = 1, R = 15000)
}
\arguments{
\item{c}{numeric, represents a positive value that defines a critical region. Default value is 1.}

\item{n}{numeric, represents the size of the sample. Default value is 100.}

\item{theta0}{numeric, represents the natural logarithm of location parameter under the null hypothesis of a sample from a Log Normal distribution. Default value is 0.}

\item{sdlog}{numeric, represents the natural logarithm of scale parameter of a Log normal distribution. It is assumed known and its default value is 1.}

\item{R}{numeric, represents the number of replicates. Default value is 15000.}
}
\value{
A list with number of replicates, sample size, and critical value that were used in the calculation of error type I
associated with a likelihood ratio statistic.
}
\description{
\code{lognorm_errorI} is used to obtain an empirical error type I when we use a random sample from a Log Normal distribution.
}
\examples{
# Error type I when we use a random sample of size 50 from an Log Normal distribution,
# a critical value c = 0.5 and R = 500 to test H_0: theta = 0 vs H_1: theta != 0
lognorm_errorI(c=0.5,n=50,theta0=0,sdlog=1,R=500)
}
\references{
Casella, G. and Berger, R. (2003). Statistical Inference, Second Edition. Duxbury Press.

Hogg, R., McKean, J., and Craig, A. (2019) Introduction to Mathematical Statistic.  Eighth edition. Pearson.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
