#' STV formula
#'
#' @rdname ElecFuns
#' @export
#' @importFrom STV stv
#' 
#'
#' @examples 
#' 
#' stv (v=ranked, m=2)

stv <- function(v, 
                m,
                ...){
  requireNamespace("STV", quietly = TRUE)
  
  cands <- unique(c(v))
  if(any(cands==0)){
    cands <- cands[-which(cands==0)]
  }
  n_cand <- length(cands)
  ## Convert to format required by STV package
  ballots <- t(apply(v, 2, 
                     function(x, n, id){
                       cands_tmp <- rep(NA,n)
                       if(all(x!=0)){
                         cands_tmp[match(x,id)] <- 1:length(x)
                       }
                       return(cands_tmp)
                     }, n = n_cand, id = cands))
  colnames(ballots) <- cands
  viable_party <- which(apply(ballots, 2, function(x)!all(is.na(x))))
  viable_votes <- which(apply(ballots, 1, function(x)!all(is.na(x))))
  stv_ballots <- as.data.frame(ballots[viable_votes,viable_party])
  
  ## Use stv function
  seats <- rep(0, n_cand)
  names(seats) <- cands
  seated <- match(STV::stv(stv_ballots, m)$elected, names(stv_ballots))
  seats[viable_party[seated]] <- 1
  return(seats)
}