/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaSymmetricalDist;
import umontreal.iro.lecuyer.randvar.BetaSymmetricalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaSymmetricalPolarGen
extends BetaSymmetricalGen {
    private double afactor;
    private RandomStream stream2;

    public BetaSymmetricalPolarGen(RandomStream s1, RandomStream s2, double alpha) {
        super(s1, null);
        this.stream2 = s2;
        if (alpha <= 0.5) {
            throw new IllegalArgumentException("  must have alpha > 1/2");
        }
        this.afactor = 2.0 / (2.0 * alpha - 1.0);
        this.setParams(alpha, alpha, 0.0, 1.0);
    }

    public BetaSymmetricalPolarGen(RandomStream s1, double alpha) {
        this(s1, s1, alpha);
    }

    public BetaSymmetricalPolarGen(RandomStream s1, RandomStream s2, BetaSymmetricalDist dist) {
        super(s1, dist);
        this.stream2 = s2;
        double alp = dist.getAlpha();
        if (alp <= 0.5) {
            throw new IllegalArgumentException("  must have alpha > 1/2");
        }
        this.afactor = 2.0 / (2.0 * dist.getAlpha() - 1.0);
        this.setParams(alp, alp, 0.0, 1.0);
    }

    public BetaSymmetricalPolarGen(RandomStream s1, BetaSymmetricalDist dist) {
        this(s1, s1, dist);
    }

    public static double nextDouble(RandomStream s1, RandomStream s2, double alpha) {
        double v;
        double u;
        double S;
        while ((S = (u = s1.nextDouble()) * u + (v = -1.0 + 2.0 * s2.nextDouble()) * v) > 1.0) {
        }
        return 0.5 + u * v / S * Math.sqrt(1.0 - Math.pow(S, 2.0 / (2.0 * alpha - 1.0)));
    }

    public static double nextDouble(RandomStream s, double alpha) {
        return BetaSymmetricalPolarGen.nextDouble(s, s, alpha);
    }

    public double nextDouble() {
        double v;
        double u;
        double S;
        while ((S = (u = this.stream.nextDouble()) * u + (v = -1.0 + 2.0 * this.stream2.nextDouble()) * v) > 1.0) {
        }
        return 0.5 + u * v / S * Math.sqrt(1.0 - Math.pow(S, this.afactor));
    }

    public RandomStream getStream2() {
        return this.stream2;
    }
}

