% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S.test.R
\name{S.test}
\alias{S.test}
\title{S test of Berger (1996)}
\usage{
S.test(u1, u2, alpha)
}
\arguments{
\item{u1}{a numerical value between 0 and 1.}

\item{u2}{a numerical value between 0 and 1.}

\item{alpha}{a numerical variable specifying the significance level for the
test.}
}
\value{
If (u1, u2) falls in the rejection region of the S test, a 1 is
returned; otherwise a 0 is returned.
}
\description{
\code{S.test} conducts the S test proposed in Berger (1996)
}
\examples{
S.test(0.1, 0.4, 0.05)

}
\references{
Berger, R.L. (1997) Likelihood ratio tests and
intersection-union tests. Advances in statistical decision theory and
applications. Birkh\"auser Boston, 225-237.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
