% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLUE_estimates_BT.R
\name{BLUE_estimates_BT}
\alias{BLUE_estimates_BT}
\title{BLUE_estimates_BT function}
\usage{
BLUE_estimates_BT(
  discovery_pheno,
  discovery_geno_mat,
  target_pheno,
  target_geno_mat,
  significance_level = 0.05,
  max_iterations = 100
)
}
\arguments{
\item{discovery_pheno}{Character. Path to the phenotype file for the discovery dataset. Assumes no header and that the binary trait is in the third column.}

\item{discovery_geno_mat}{Character. Path to the genotype matrix file for the discovery dataset. Assumes no header.}

\item{target_pheno}{Character. Path to the phenotype file for the target dataset. Assumes no header and individual IDs in the second column.}

\item{target_geno_mat}{Character. Path to the genotype matrix file for the target dataset. Assumes no header.}

\item{significance_level}{Numeric. Significance level for confidence intervals (e.g., 0.05 for 95\% CI). Default is 0.05.}

\item{max_iterations}{Integer. Maximum number of iterations allowed in Firth logistic regression. Default is 100.}
}
\value{
A data frame with the following columns:
\describe{
\item{IID}{Individual identifier (from the target phenotype file).}
\item{PRS}{Estimated polygenic risk score for each individual.}
\item{Variance}{Estimated variance of the PRS.}
\item{Lower_Limit}{Lower bound of the confidence interval.}
\item{Upper_Limit}{Upper bound of the confidence interval.}
}
}
\description{
Estimates individual-level polygenic risk scores (PRS) with uncertainty using a frequentist approach
for binary traits. This implementation applies Firth's bias-reduced logistic regression on the discovery sample,
computes the coefficient covariance matrix, and uses the delta method to derive PRS variance and confidence intervals.
}
\details{
The function fits a Firth logistic regression model using the \code{logistf} package to reduce small-sample bias in the discovery set.
It extracts SNP effect estimates and their covariance matrix, and propagates this uncertainty through to the individual-level
PRS in the target dataset via the delta method. Confidence intervals are derived assuming normality.

Missing or non-estimable coefficients and variances are set to zero.
}
\examples{
  bpd <- system.file("Bpd_0_1.txt", package = "iPRSue", mustWork = TRUE)
  bpt <- system.file("Bpt.txt", package = "iPRSue", mustWork = TRUE)
  gd  <- system.file("Gd.txt",  package = "iPRSue", mustWork = TRUE)
  gt  <- system.file("Gt.txt",  package = "iPRSue", mustWork = TRUE)

  results <- BLUE_estimates_BT(
    discovery_pheno    = bpd,
    discovery_geno_mat = gd,
    target_pheno       = bpt,
    target_geno_mat    = gt,
    significance_level = 0.05,
    max_iterations     = 100
  )
  head(results)

}
