% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_annotate_samples.R
\name{ifcb_annotate_samples}
\alias{ifcb_annotate_samples}
\title{Create Manual Classification MAT Files from PNG Subfolders}
\usage{
ifcb_annotate_samples(
  png_folder,
  adc_folder,
  class2use_file,
  output_folder,
  sample_names = NULL,
  unclassified_id = 1,
  remove_trailing_numbers = TRUE,
  do_compression = TRUE
)
}
\arguments{
\item{png_folder}{Directory containing PNG images organized into
subfolders named after classes. Each PNG file represents a single ROI
extracted from an IFCB sample and must follow the standard IFCB naming
convention (for example, \code{"D20220712T210855_IFCB134_00042.png"}), which
is used to map the image to the corresponding ROI index in the ADC file.}

\item{adc_folder}{Directory containing ADC files for the samples.}

\item{class2use_file}{Path to a \code{class2use} MAT file. This file should
contain the vector of classes used for matching PNG annotations to class IDs.}

\item{output_folder}{Directory where the resulting MAT files will be written.
If the folder does not exist, it will be created automatically.}

\item{sample_names}{Optional character vector of IFCB sample names
(e.g., \code{"D20220712T210855_IFCB134"}). If \code{NULL} (default), all samples
detected from the PNG filenames in \code{png_folder} will be processed.
Each sample must have a corresponding ADC file in \code{adc_folder}.}

\item{unclassified_id}{An integer specifying the class ID to use for unclassified
regions of interest (ROIs) when creating new manual \code{.mat} files. Default is \code{1}.}

\item{remove_trailing_numbers}{Logical. If TRUE (default), trailing numeric
suffixes are removed from PNG subfolder names before matching them to
entries in \code{class2use} (for example, \code{"Skeletonema_036"} becomes
\code{"Skeletonema"}). This is useful when class folders include numeric
identifiers that are not part of the class names in \code{class2use}.}

\item{do_compression}{A logical value indicating whether to compress the \code{.mat} file. Default is TRUE.}
}
\value{
Invisibly returns \code{TRUE} on successful completion.
}
\description{
This function creates manual classification \code{.mat} files compatible with the
code in the \code{ifcb-analysis} MATLAB repository (Sosik and Olson 2007) by
mapping ROIs to class IDs based on user-provided PNG images (organized into
subfolders named after classes) and a \code{class2use} MAT file.
}
\details{
Python must be installed to use this function. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.

Each sample should have ADC files in \code{adc_folder} and corresponding PNG images
stored in subfolders under \code{png_folder}, where each subfolder is named after
a class (e.g., \code{Skeletonema}, \code{Dinophysis_acuminata}, \code{unclassified}). The function
automatically maps PNG filenames to ROI indices, assigns class IDs based on
\code{class2use}, and writes the resulting MAT file in \code{output_folder}.
\itemize{
\item The function reads all PNG images in subfolders of \code{png_folder}, extracts
class names from folder names, and converts PNG filenames to ROI indices
using \code{ifcb_convert_filenames()}.
\item Class IDs are assigned using \code{match()} against \code{class2use}. If any
classes cannot be matched, a warning lists the unmatched classes and
shows the \code{ifcb_get_mat_variable()} command to inspect available classes.
\item The function writes one MAT file per sample using
\code{ifcb_create_manual_file()}.
}
}
\examples{
\dontrun{
# Example: Annotate a single IFCB sample
sample_names <- "D20220712T210855_IFCB134"
png_folder <- "data/annotated_png_images/"
adc_folder <- "data/raw"
class2use_file <- "data/manual/class2use.mat"
output_folder <- "data/manual/"

# Create manual MAT file for this sample
ifcb_annotate_samples(
  png_folder = png_folder,
  adc_folder = adc_folder,
  class2use_file = class2use_file,
  output_folder = output_folder,
  sample_names = sample_names
)
}

}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_py_install}} \code{\link{ifcb_create_class2use}} \url{https://github.com/hsosik/ifcb-analysis}
}
