% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{noisy_data}
\alias{noisy_data}
\title{Noisy Data From a Tenth Order Polynomial}
\format{
a list of two tibbles with two columns each. \eqn{x} stands for the
independent, \eqn{y} for the dependent variable. The training data
(\code{noisy_data$train}) contains 1000 rows, the test data (\code{noisy_data$test})
20 rows.
}
\usage{
noisy_data
}
\description{
Training and test data created from a tenth order polynomial with added noise.
The polynomial is given by
\deqn{f(x) = 2 x - 10 x^5 + 15 x^{10}}{f(x) = 2 x - 10 x^5 + 15 x^10}
The noise follows a standard normal distribution. The data can be used to
demonstrate overfitting. It is inspired by section II. B. in
\href{https://arxiv.org/abs/1803.08823}{A high-bias, low-variance introduction to Machine Learning for physicists}
}
\references{
P. Mehta et al.,
\emph{A high-bias, low-variance introduction to Machine Learning for physicists}
Phys. Rep. 810 (2019), 1-124.
\href{https://arxiv.org/abs/1803.08823}{arXiv:1803.08823}
\doi{10.1016/j.physrep.2019.03.001}
}
\keyword{datasets}
